/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import walnoot.swarm.Util;
import walnoot.swarm.World;
import walnoot.swarm.screens.EndScreen;
import walnoot.swarm.screens.UpdateScreen;

public class GameScreen
extends UpdateScreen {
    private static final Vector3 TMP = new Vector3();
    private World world;
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private Stage stage;
    private Label counterLabel;
    private Label infoLabel;
    private Label nameLabel;
    private Label hintLabel;
    private TextButton button;
    private Json json;
    private JsonValue jsonValue;
    private String level;
    private Sprite backgroundSprite;

    public GameScreen(String level) {
        this.level = level;
    }

    @Override
    public void show() {
        Texture background = Util.assets.get("background.png", Texture.class);
        background.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        this.backgroundSprite = new Sprite(background);
        this.json = new Json();
        this.jsonValue = new JsonReader().parse(Gdx.files.internal(String.valueOf(this.level) + ".json"));
        this.world = new World(this.json, this.jsonValue);
        this.stage = new Stage();
        this.game.addInputProcessor(this.stage);
        Table table = new Table();
        this.stage.addActor(table);
        table.pad(4.0f).setFillParent(true);
        this.nameLabel = new Label((CharSequence)this.world.getName(), Util.skin);
        table.add(this.nameLabel).expand().top().left();
        this.hintLabel = new Label(null, Util.skin);
        table.add(this.hintLabel).expand().colspan(2).top().right().row();
        this.infoLabel = new Label((CharSequence)"Place bait", Util.skin);
        table.add(this.infoLabel).expandX().height(50.0f);
        this.counterLabel = new Label(null, Util.skin);
        table.add(this.counterLabel).expandX().height(50.0f);
        this.button = new TextButton("Start", Util.skin);
        this.button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                TextButton button = (TextButton)actor;
                if (GameScreen.this.world.isFinished()) {
                    GameScreen.this.nextLevel();
                } else if (GameScreen.this.world.isStarted()) {
                    GameScreen.this.reset();
                    button.setText("Start");
                } else {
                    GameScreen.this.world.start();
                    button.setText("Reset");
                }
            }
        });
        this.button.addListener(Util.CLICK_LISTENER);
        table.add(this.button).expandX().fill();
    }

    private void reset() {
        this.world.reset();
        this.hintLabel.setText(this.jsonValue.getString("hint", null));
    }

    private void nextLevel() {
        Util.playSound("nextlevel");
        this.hintLabel.setText(null);
        this.level = this.jsonValue.getString("nextLevel", null);
        if (this.level != null) {
            this.jsonValue = new JsonReader().parse(Gdx.files.internal(String.valueOf(this.level) + ".json"));
            this.world = new World(this.json, this.jsonValue);
            this.nameLabel.setText(this.world.getName());
            this.button.setText("Start");
            Gdx.app.getPreferences("Swarm").putString("currentLevel", this.level);
        } else {
            this.game.setScreen(new EndScreen());
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl20.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl20.glClear(16384);
        this.batch.begin();
        this.backgroundSprite.draw(this.batch);
        this.world.render(this.batch);
        this.batch.end();
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void update() {
        this.world.update();
        this.counterLabel.setText(String.format("%d/%d flies", this.world.getMaxFliesFinished(), this.world.getRequiredFlies()));
        this.infoLabel.setText(this.world.isStarted() ? "Get the flies to the goal" : "Place Bait by clicking");
        if (this.world.isFinished()) {
            this.button.setText("Continue");
        }
    }

    @Override
    public void resize(int width, int height) {
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.zoom = 16.0f;
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.stage.setViewport(width, height);
        float bWidth = this.camera.viewportWidth * this.camera.zoom;
        float bHeight = this.camera.viewportHeight * this.camera.zoom;
        this.backgroundSprite.setRegion(0.0f, 0.0f, bWidth * 0.5f, bHeight * 0.5f);
        this.backgroundSprite.setSize(bWidth, bHeight);
        this.backgroundSprite.setPosition(-bWidth * 0.5f, -bHeight * 0.5f);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.camera.unproject(TMP.set(screenX, screenY, 0.0f));
        if (button == 0) {
            this.world.addAttractEntity(GameScreen.TMP.x, GameScreen.TMP.y);
        } else if (button == 1) {
            this.world.destroyAttractEntity(GameScreen.TMP.x, GameScreen.TMP.y);
        }
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 66) {
            this.world.start();
        }
        return true;
    }
}

