/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.entities;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import walnoot.swarm.entities.Entity;
import walnoot.swarm.entities.FlyEntity;
import walnoot.swarm.entities.SpriteEntity;

public class SwatterEntity
extends SpriteEntity {
    private static final Vector2 HIT_POSITION = new Vector2(0.75f, -0.5f);
    private static final Vector2 TMP = new Vector2();
    private static final float HIT_RADIUS = 1.0f;
    private Vector2 hitPos = new Vector2(HIT_POSITION);

    public SwatterEntity(boolean flip) {
        super("swatter", 4.0f, 4.0f, 0.4f, MathUtils.random());
        if (flip) {
            this.hitPos.x = -this.hitPos.x;
            this.flip(true, false);
        }
    }

    @Override
    public void update() {
        super.update();
        int i = 0;
        while (i < this.world.getEntities().size) {
            Entity entity = (Entity)this.world.getEntities().get(i);
            if (entity instanceof FlyEntity && TMP.set(this.pos).add(this.hitPos).dst2(entity.pos) < 1.0f) {
                entity.remove();
            }
            ++i;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected int getRenderLayer() {
        return 1;
    }
}

