/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.entities;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.swarm.Animation;
import walnoot.swarm.entities.Entity;

public abstract class SpriteEntity
extends Entity {
    private final float width;
    private final float height;
    protected Animation animation;

    public SpriteEntity(String spriteName, float animationTime) {
        this(spriteName, 1.0f, 1.0f, animationTime, 0.0f);
    }

    public SpriteEntity(String spriteName, float animationTime, float startTime) {
        this(spriteName, 1.0f, 1.0f, animationTime, startTime);
    }

    public SpriteEntity(String spriteName, float width, float height, float animationTime, float startTime) {
        this.width = width;
        this.height = height;
        this.animation = new Animation(spriteName, animationTime, startTime);
        for (Sprite sprite : this.animation.getSprites()) {
            sprite.setSize(width, height);
            sprite.setOrigin(width * 0.5f, height * 0.5f);
        }
    }

    @Override
    public void update() {
        this.animation.update();
    }

    @Override
    public void render(SpriteBatch batch) {
        Sprite sprite = this.animation.getSprite();
        sprite.setPosition(this.pos.x - this.width * 0.5f, this.pos.y - this.height * 0.5f);
        sprite.draw(batch);
    }

    public void flip(boolean x, boolean y) {
        for (Sprite s : this.animation.getSprites()) {
            s.flip(x, y);
        }
    }
}

