/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.entities;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import walnoot.swarm.Util;
import walnoot.swarm.entities.AttractEntity;
import walnoot.swarm.entities.BloodEntity;
import walnoot.swarm.entities.Entity;
import walnoot.swarm.entities.SpriteEntity;

public class FlyEntity
extends SpriteEntity {
    private static final float AVOIDANCE_RADIUS = 0.5f;
    private static final float AVOIDANCE_STRENGTH = 3.0f;
    private static final float COHESION_STRENGTH = 0.004f;
    private static final float ATTRACT_STRENGTH = 5.0f;
    private static final float ATTRACT_RADIUS = 5.0f;
    private static final Vector2 TMP = new Vector2();

    public FlyEntity() {
        super("fly", 0.2f, MathUtils.random());
    }

    @Override
    public void update() {
        super.update();
        this.pos.x += MathUtils.random(-1.0f, 1.0f) * 0.016666668f * 2.0f;
        this.pos.y += MathUtils.random(-1.0f, 1.0f) * 0.016666668f * 2.0f;
        float closestAttractDist2 = Float.MAX_VALUE;
        AttractEntity closestAttract = null;
        int i = 0;
        while (i < this.world.getEntities().size) {
            float dist;
            Entity e = (Entity)this.world.getEntities().get(i);
            if (e instanceof FlyEntity) {
                if (TMP.set(this.pos).sub(e.pos).len2() < 0.25f) {
                    this.pos.add(TMP.nor().scl(0.050000004f));
                }
            } else if (e instanceof AttractEntity && (dist = TMP.set(this.pos).dst2(e.pos)) < closestAttractDist2) {
                closestAttractDist2 = dist;
                closestAttract = (AttractEntity)e;
            }
            ++i;
        }
        if (closestAttract != null) {
            float strength = Math.min(closestAttractDist2, 5.0f) / 5.0f * 5.0f;
            this.pos.add(TMP.set(closestAttract.pos).sub(this.pos).nor().scl(0.016666668f * strength));
            if (closestAttractDist2 < 1.0f) {
                closestAttract.markRemoval();
            }
        }
        this.pos.add(TMP.set(this.world.avgFlyPos).sub(this.pos).nor().scl(6.6666675E-5f * this.world.avgFlyPos.dst2(this.pos)));
        this.world.cumFlyPos.add(this.pos);
        ++this.world.numFlies;
    }

    @Override
    protected void onRemove() {
        this.world.addEntity(new BloodEntity(this.pos));
        Util.playSound("kill");
    }
}

