/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.entities;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import walnoot.swarm.World;

public abstract class Entity
implements Comparable<Entity> {
    public World world;
    public Vector2 pos = new Vector2();
    public Vector2 prevPos = new Vector2();

    public abstract void render(SpriteBatch var1);

    public abstract void update();

    @Override
    public int compareTo(Entity o) {
        if (this.getRenderLayer() > o.getRenderLayer()) {
            return 1;
        }
        if (this.getRenderLayer() < o.getRenderLayer()) {
            return -1;
        }
        return (int)Math.signum(o.pos.y - this.pos.y);
    }

    public void remove() {
        this.world.removeEntity(this);
        this.onRemove();
    }

    protected void onRemove() {
    }

    protected int getRenderLayer() {
        return 0;
    }

    public boolean isPersistent() {
        return false;
    }
}

