/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.entities;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import walnoot.swarm.Util;
import walnoot.swarm.entities.Entity;
import walnoot.swarm.entities.FlyEntity;
import walnoot.swarm.entities.SpriteEntity;

public class BladeEntity
extends SpriteEntity {
    private static final float SPIN_SPEED = 20.0f;
    private static final float HIT_RADIUS = 2.0f;
    private static final Vector2 TMP = new Vector2();
    private Vector2 path;
    private Vector2 startPos;
    private int timer;
    private final float speed;
    private boolean isBloody = false;

    public BladeEntity(float x, float y, float width, float height, float speed) {
        super("blade", 4.0f, 4.0f, 1.0f, 0.0f);
        this.startPos = new Vector2(x, y);
        this.path = new Vector2(width, height);
        this.speed = speed / ((float)Math.PI * 2);
    }

    @Override
    public void render(SpriteBatch batch) {
        this.animation.getSprite().rotate(0.33333334f);
        super.render(batch);
    }

    @Override
    public void update() {
        super.update();
        this.timer = this.world.isStarted() ? ++this.timer : 0;
        this.pos.set(this.startPos).add(MathUtils.sin((float)this.timer * this.speed) * this.path.x, MathUtils.cos((float)this.timer * this.speed) * this.path.y);
        int i = 0;
        while (i < this.world.getEntities().size) {
            Entity entity = (Entity)this.world.getEntities().get(i);
            if (entity instanceof FlyEntity && TMP.set(this.pos).dst2(entity.pos) < 4.0f) {
                entity.remove();
                if (!this.isBloody) {
                    this.animation.getSprite().setRegion(Util.atlas.findRegion("blade_bloody"));
                    this.isBloody = true;
                }
            }
            ++i;
        }
    }

    @Override
    protected int getRenderLayer() {
        return 1;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }
}

