/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import walnoot.swarm.Util;
import walnoot.swarm.entities.AttractEntity;
import walnoot.swarm.entities.BladeEntity;
import walnoot.swarm.entities.Entity;
import walnoot.swarm.entities.FlyEntity;
import walnoot.swarm.entities.SwatterEntity;

public class World {
    public Vector2 cumFlyPos = new Vector2();
    public Vector2 avgFlyPos = new Vector2();
    public int numFlies;
    private String name;
    private Sprite goalSprite;
    private Sprite startSprite;
    private Rectangle goal;
    private Vector2 start;
    private DelayedRemovalArray<Entity> entities = new DelayedRemovalArray();
    private int requiredFlies;
    private int numFinishedFlies;
    private int maxFliesFinished;
    private int startFlies;
    private boolean started;

    public World(Json json, JsonValue jsonValue) {
        JsonValue blades;
        this.name = jsonValue.getString("name", "");
        this.goal = json.readValue(Rectangle.class, jsonValue.get("goal"));
        this.start = json.readValue(Vector2.class, jsonValue.get("start"));
        if (this.start == null) {
            this.start = new Vector2();
        }
        this.requiredFlies = jsonValue.getInt("requiredFlies", 10);
        this.startFlies = jsonValue.getInt("startFlies", 100);
        this.goalSprite = Util.atlas.createSprite("goal");
        this.goalSprite.setBounds(this.goal.x, this.goal.y, this.goal.width, this.goal.height);
        this.startSprite = Util.atlas.createSprite("repel");
        this.startSprite.setSize(1.0f, 1.0f);
        this.startSprite.setPosition(this.start.x - 0.5f, this.start.y - 0.5f);
        JsonValue swatters = jsonValue.get("swatters");
        if (swatters != null) {
            this.addObstacles(swatters, true);
        }
        if ((blades = jsonValue.get("blades")) != null) {
            this.addObstacles(blades, false);
        }
    }

    private void addObstacles(JsonValue swatters, boolean isSwatter) {
        JsonValue currentValue = swatters.child;
        while (currentValue != null) {
            if (isSwatter) {
                boolean flip = currentValue.get(2) == null ? false : currentValue.getBoolean(2);
                SwatterEntity swatter = new SwatterEntity(flip);
                swatter.pos.set(currentValue.getInt(0), currentValue.getInt(1));
                this.addEntity(swatter);
            } else {
                float width = currentValue.get(2) == null ? 0.0f : currentValue.getFloat(2);
                float height = currentValue.get(3) == null ? 0.0f : currentValue.getFloat(3);
                float speed = currentValue.get(4) == null ? 0.0f : currentValue.getFloat(4);
                BladeEntity blade = new BladeEntity(currentValue.getFloat(0), currentValue.getFloat(1), width, height, speed);
                this.addEntity(blade);
            }
            currentValue = currentValue.next;
        }
    }

    public void render(SpriteBatch batch) {
        this.goalSprite.draw(batch);
        if (!this.started) {
            this.startSprite.draw(batch);
        }
        for (Entity e : this.entities) {
            e.render(batch);
        }
    }

    public void update() {
        this.entities.begin();
        int numFinishedFlies = 0;
        for (Entity e : this.entities) {
            e.update();
            if (!(e instanceof FlyEntity) || !this.goal.contains(e.pos)) continue;
            ++numFinishedFlies;
        }
        for (Entity e : this.entities) {
            e.prevPos.set(e.pos);
        }
        this.numFinishedFlies = numFinishedFlies;
        this.maxFliesFinished = Math.max(numFinishedFlies, this.maxFliesFinished);
        this.entities.end();
        this.entities.sort();
        if (this.numFlies > 0) {
            this.avgFlyPos.set(this.cumFlyPos).div(this.numFlies);
            this.cumFlyPos.set(0.0f, 0.0f);
            this.numFlies = 0;
        }
    }

    public void start() {
        if (!this.started) {
            int i = 0;
            while (i < this.startFlies) {
                FlyEntity entity = new FlyEntity();
                entity.pos.set(MathUtils.random(-3.0f, 3.0f) + this.start.x, MathUtils.random(-3.0f, 3.0f) + this.start.y);
                this.addEntity(entity);
                ++i;
            }
        }
        this.started = true;
    }

    public void reset() {
        this.started = false;
        this.entities.begin();
        for (Entity e : this.entities) {
            if (e.isPersistent()) continue;
            this.removeEntity(e);
        }
        this.entities.end();
        this.maxFliesFinished = 0;
        this.numFinishedFlies = 0;
    }

    public void addAttractEntity(float x, float y) {
        if (!this.started) {
            AttractEntity attractEntity = new AttractEntity();
            attractEntity.pos.set(x, y);
            this.addEntity(attractEntity);
        }
    }

    public void destroyAttractEntity(float x, float y) {
        if (!this.started) {
            this.entities.begin();
            for (Entity e : this.entities) {
                if (!(e instanceof AttractEntity) || !(e.pos.dst2(x, y) < 1.0f)) continue;
                e.remove();
            }
            this.entities.end();
        }
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
        e.world = this;
    }

    public void removeEntity(Entity e) {
        this.entities.removeValue(e, true);
    }

    public int getNumFinishedFlies() {
        return this.numFinishedFlies;
    }

    public int getStartFlies() {
        return this.startFlies;
    }

    public int getMaxFliesFinished() {
        return this.maxFliesFinished;
    }

    public int getRequiredFlies() {
        return this.requiredFlies;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFinished() {
        return this.maxFliesFinished >= this.requiredFlies;
    }

    public boolean isStarted() {
        return this.started;
    }

    public DelayedRemovalArray<Entity> getEntities() {
        return this.entities;
    }
}

