/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.FPSLogger;
import walnoot.swarm.screens.LoadingScreen;
import walnoot.swarm.screens.UpdateScreen;

public class SwarmApplication
extends Game {
    public static final float UPDATES_PER_SECOND = 60.0f;
    public static final float SECONDS_PER_UPDATE = 0.016666668f;
    private UpdateScreen updateScreen;
    private float unprocessedSeconds;
    private InputMultiplexer inputs = new InputMultiplexer();
    private FPSLogger logger = new FPSLogger();

    @Override
    public void create() {
        this.setScreen(new LoadingScreen());
        Gdx.input.setInputProcessor(this.inputs);
    }

    @Override
    public void render() {
        this.logger.log();
        this.unprocessedSeconds += Gdx.graphics.getDeltaTime();
        while (this.unprocessedSeconds > 0.016666668f) {
            this.unprocessedSeconds -= 0.016666668f;
            this.updateScreen.update();
        }
        super.render();
    }

    @Override
    public void setScreen(Screen screen) {
        if (!(screen instanceof UpdateScreen)) {
            throw new IllegalArgumentException();
        }
        this.updateScreen = (UpdateScreen)screen;
        this.updateScreen.game = this;
        this.inputs.clear();
        this.inputs.addProcessor(this.updateScreen);
        super.setScreen(screen);
    }

    public void addInputProcessor(InputProcessor input) {
        this.inputs.addProcessor(0, input);
    }

    @Override
    public void dispose() {
        super.dispose();
        Gdx.app.getPreferences("Swarm").flush();
    }
}

