/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetJavaImpl {
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public void sendHttpRequest(final Net.HttpRequest httpRequest, final Net.HttpResponseListener httpResponseListener) {
        if (httpRequest.getUrl() == null) {
            httpResponseListener.failed(new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            URL url;
            String method = httpRequest.getMethod();
            if (method.equalsIgnoreCase("GET")) {
                String queryString = "";
                String value = httpRequest.getContent();
                if (value != null && !"".equals(value)) {
                    queryString = "?" + value;
                }
                url = new URL(httpRequest.getUrl() + queryString);
            } else {
                url = new URL(httpRequest.getUrl());
            }
            final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            final boolean doingOutPut = method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT");
            connection.setDoOutput(doingOutPut);
            connection.setDoInput(true);
            connection.setRequestMethod(method);
            for (Map.Entry<String, String> header : httpRequest.getHeaders().entrySet()) {
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
            connection.setConnectTimeout(httpRequest.getTimeOut());
            connection.setReadTimeout(httpRequest.getTimeOut());
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (doingOutPut) {
                            String contentAsString = httpRequest.getContent();
                            InputStream contentAsStream = httpRequest.getContentStream();
                            OutputStream outputStream = connection.getOutputStream();
                            if (contentAsString != null) {
                                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                                writer.write(contentAsString);
                                writer.flush();
                                writer.close();
                            } else if (contentAsStream != null) {
                                StreamUtils.copyStream(contentAsStream, outputStream);
                                outputStream.flush();
                                outputStream.close();
                            }
                        }
                        connection.connect();
                        HttpClientResponse clientResponse = new HttpClientResponse(connection);
                        try {
                            httpResponseListener.handleHttpResponse(clientResponse);
                        }
                        finally {
                            connection.disconnect();
                        }
                    }
                    catch (Exception e) {
                        connection.disconnect();
                        httpResponseListener.failed(e);
                    }
                }
            });
        }
        catch (Exception e) {
            httpResponseListener.failed(e);
            return;
        }
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private HttpURLConnection connection;
        private HttpStatus status;
        private InputStream inputStream;

        public HttpClientResponse(HttpURLConnection connection) throws IOException {
            this.connection = connection;
            try {
                this.inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                this.inputStream = connection.getErrorStream();
            }
            try {
                this.status = new HttpStatus(connection.getResponseCode());
            }
            catch (IOException e) {
                this.status = new HttpStatus(-1);
            }
        }

        @Override
        public byte[] getResult() {
            try {
                return StreamUtils.copyStreamToByteArray(this.inputStream, this.connection.getContentLength());
            }
            catch (IOException e) {
                return StreamUtils.EMPTY_BYTES;
            }
        }

        @Override
        public String getResultAsString() {
            try {
                return StreamUtils.copyStreamToString(this.inputStream, this.connection.getContentLength());
            }
            catch (IOException e) {
                return "";
            }
        }

        @Override
        public InputStream getResultAsStream() {
            return this.inputStream;
        }

        @Override
        public HttpStatus getStatus() {
            return this.status;
        }

        @Override
        public String getHeader(String name) {
            return this.connection.getHeaderField(name);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.connection.getHeaderFields();
        }
    }
}

