/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;

public class GeometryUtils {
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();

    public static Vector2 toBarycoord(Vector2 p, Vector2 a, Vector2 b, Vector2 c, Vector2 barycentricOut) {
        Vector2 v0 = tmp1.set(b).sub(a);
        Vector2 v1 = tmp2.set(c).sub(a);
        Vector2 v2 = tmp3.set(p).sub(a);
        float d00 = v0.dot(v0);
        float d01 = v0.dot(v1);
        float d11 = v1.dot(v1);
        float d20 = v2.dot(v0);
        float d21 = v2.dot(v1);
        float denom = d00 * d11 - d01 * d01;
        barycentricOut.x = (d11 * d20 - d01 * d21) / denom;
        barycentricOut.y = (d00 * d21 - d01 * d20) / denom;
        return barycentricOut;
    }

    public static boolean barycoordInsideTriangle(Vector2 barycentric) {
        return barycentric.x >= 0.0f && barycentric.y >= 0.0f && barycentric.x + barycentric.y <= 1.0f;
    }

    public static Vector2 fromBarycoord(Vector2 barycentric, Vector2 a, Vector2 b, Vector2 c, Vector2 interpolatedOut) {
        float u = 1.0f - barycentric.x - barycentric.y;
        interpolatedOut.x = u * a.x + barycentric.x * b.x + barycentric.y * c.x;
        interpolatedOut.y = u * a.y + barycentric.x * b.y + barycentric.y * c.y;
        return interpolatedOut;
    }

    public static Vector2 fromBarycoord(Vector2 barycentric, float a, float b, float c, Vector2 interpolatedOut) {
        float u = 1.0f - barycentric.x - barycentric.y;
        interpolatedOut.x = u * a + barycentric.x * b + barycentric.y * c;
        return interpolatedOut;
    }

    public static float lowestPositiveRoot(float a, float b, float c) {
        float r2;
        float invA;
        float det = b * b - 4.0f * a * c;
        if (det < 0.0f) {
            return Float.NaN;
        }
        float sqrtD = (float)Math.sqrt(det);
        float r1 = (-b - sqrtD) * (invA = 1.0f / (2.0f * a));
        if (r1 > (r2 = (-b + sqrtD) * invA)) {
            float tmp = r2;
            r2 = r1;
            r1 = tmp;
        }
        if (r1 > 0.0f) {
            return r1;
        }
        if (r2 > 0.0f) {
            return r2;
        }
        return Float.NaN;
    }

    public static Vector2 triangleCentroid(float x1, float y1, float x2, float y2, float x3, float y3, Vector2 centroid) {
        centroid.x = (x1 + x2 + x3) / 3.0f;
        centroid.y = (y1 + y2 + y3) / 3.0f;
        return centroid;
    }

    public static float triangleArea(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1)) * 0.5f;
    }

    public static Vector2 quadrilateralCentroid(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vector2 centroid) {
        float avgX1 = (x1 + x2 + x3) / 3.0f;
        float avgY1 = (y1 + y2 + y3) / 3.0f;
        float avgX2 = (x1 + x4 + x3) / 3.0f;
        float avgY2 = (y1 + y4 + y3) / 3.0f;
        centroid.x = avgX1 - (avgX1 - avgX2) / 2.0f;
        centroid.y = avgY1 - (avgY1 - avgY2) / 2.0f;
        return centroid;
    }

    public static Vector2 polygonCentroid(float[] polygon, int offset, int count, Vector2 centroid) {
        int i;
        if (polygon.length < 6) {
            throw new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        }
        float x = 0.0f;
        float y = 0.0f;
        float signedArea = 0.0f;
        int n = offset + count - 2;
        for (i = offset; i < n; i += 2) {
            float x0 = polygon[i];
            float y0 = polygon[i + 1];
            float x1 = polygon[i + 2];
            float y1 = polygon[i + 3];
            float a = x0 * y1 - x1 * y0;
            signedArea += a;
            x += (x0 + x1) * a;
            y += (y0 + y1) * a;
        }
        float x0 = polygon[i];
        float y0 = polygon[i + 1];
        float x1 = polygon[offset];
        float y1 = polygon[offset + 1];
        float a = x0 * y1 - x1 * y0;
        signedArea += a;
        centroid.x = (x += (x0 + x1) * a) / (6.0f * (signedArea *= 0.5f));
        centroid.y = (y += (y0 + y1) * a) / (6.0f * signedArea);
        return centroid;
    }

    public static float polygonArea(float[] polygon, int offset, int count) {
        float area = 0.0f;
        int n = offset + count;
        for (int i = offset; i < n; i += 2) {
            int x1 = i;
            int y1 = i + 1;
            int x2 = (i + 2) % n;
            int y2 = (i + 3) % n;
            area += polygon[x1] * polygon[y2];
            area -= polygon[x2] * polygon[y1];
        }
        return area *= 0.5f;
    }
}

