/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;

public class TmxMapLoader
extends AsynchronousAssetLoader<TiledMap, Parameters> {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    protected XmlReader xml = new XmlReader();
    protected XmlReader.Element root;
    protected boolean yUp;
    protected boolean convertObjectToTileSpace;
    protected int mapTileWidth;
    protected int mapTileHeight;
    protected int mapWidthInPixels;
    protected int mapHeightInPixels;
    protected TiledMap map;

    public TmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new Parameters());
    }

    public TiledMap load(String fileName, Parameters parameters) {
        try {
            this.yUp = parameters.yUp;
            this.convertObjectToTileSpace = parameters.convertObjectToTileSpace;
            FileHandle tmxFile = this.resolve(fileName);
            this.root = this.xml.parse(tmxFile);
            ObjectMap<String, Texture> textures = new ObjectMap<String, Texture>();
            for (FileHandle textureFile : this.loadTilesets(this.root, tmxFile)) {
                Texture texture = new Texture(textureFile, parameters.generateMipMaps);
                texture.setFilter(parameters.textureMinFilter, parameters.textureMagFilter);
                textures.put(textureFile.path(), texture);
            }
            ImageResolver.DirectImageResolver imageResolver = new ImageResolver.DirectImageResolver(textures);
            TiledMap map = this.loadTilemap(this.root, tmxFile, imageResolver);
            map.setOwnedResources(textures.values().toArray());
            return map;
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", e);
        }
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmxFile, Parameters parameter) {
        this.map = null;
        if (parameter != null) {
            this.yUp = parameter.yUp;
            this.convertObjectToTileSpace = parameter.convertObjectToTileSpace;
        } else {
            this.yUp = true;
            this.convertObjectToTileSpace = false;
        }
        try {
            this.map = this.loadTilemap(this.root, tmxFile, new ImageResolver.AssetManagerImageResolver(manager));
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", e);
        }
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, Parameters parameter) {
        return this.map;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle tmxFile, Parameters parameter) {
        Array<AssetDescriptor> dependencies = new Array<AssetDescriptor>();
        try {
            this.root = this.xml.parse(tmxFile);
            boolean generateMipMaps = parameter != null ? parameter.generateMipMaps : false;
            TextureLoader.TextureParameter texParams = new TextureLoader.TextureParameter();
            texParams.genMipMaps = generateMipMaps;
            if (parameter != null) {
                texParams.minFilter = parameter.textureMinFilter;
                texParams.magFilter = parameter.textureMagFilter;
            }
            for (FileHandle image : this.loadTilesets(this.root, tmxFile)) {
                dependencies.add(new AssetDescriptor<Texture>(image, Texture.class, texParams));
            }
            return dependencies;
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", e);
        }
    }

    protected TiledMap loadTilemap(XmlReader.Element root, FileHandle tmxFile, ImageResolver imageResolver) {
        TiledMap map = new TiledMap();
        String mapOrientation = root.getAttribute("orientation", null);
        int mapWidth = root.getIntAttribute("width", 0);
        int mapHeight = root.getIntAttribute("height", 0);
        int tileWidth = root.getIntAttribute("tilewidth", 0);
        int tileHeight = root.getIntAttribute("tileheight", 0);
        String mapBackgroundColor = root.getAttribute("backgroundcolor", null);
        MapProperties mapProperties = map.getProperties();
        if (mapOrientation != null) {
            mapProperties.put("orientation", mapOrientation);
        }
        mapProperties.put("width", mapWidth);
        mapProperties.put("height", mapHeight);
        mapProperties.put("tilewidth", tileWidth);
        mapProperties.put("tileheight", tileHeight);
        if (mapBackgroundColor != null) {
            mapProperties.put("backgroundcolor", mapBackgroundColor);
        }
        this.mapTileWidth = tileWidth;
        this.mapTileHeight = tileHeight;
        this.mapWidthInPixels = mapWidth * tileWidth;
        this.mapHeightInPixels = mapHeight * tileHeight;
        XmlReader.Element properties = root.getChildByName("properties");
        if (properties != null) {
            this.loadProperties(map.getProperties(), properties);
        }
        Array<XmlReader.Element> tilesets = root.getChildrenByName("tileset");
        for (XmlReader.Element element : tilesets) {
            this.loadTileSet(map, element, tmxFile, imageResolver);
            root.removeChild(element);
        }
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            XmlReader.Element element = root.getChild(i);
            String name = element.getName();
            if (name.equals("layer")) {
                this.loadTileLayer(map, element);
                continue;
            }
            if (!name.equals("objectgroup")) continue;
            this.loadObjectGroup(map, element);
        }
        return map;
    }

    protected Array<FileHandle> loadTilesets(XmlReader.Element root, FileHandle tmxFile) throws IOException {
        Array<FileHandle> images = new Array<FileHandle>();
        for (XmlReader.Element tileset : root.getChildrenByName("tileset")) {
            String source = tileset.getAttribute("source", null);
            FileHandle image = null;
            if (source != null) {
                FileHandle tsx = TmxMapLoader.getRelativeFileHandle(tmxFile, source);
                tileset = this.xml.parse(tsx);
                String imageSource = tileset.getChildByName("image").getAttribute("source");
                image = TmxMapLoader.getRelativeFileHandle(tsx, imageSource);
            } else {
                String imageSource = tileset.getChildByName("image").getAttribute("source");
                image = TmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
            }
            images.add(image);
        }
        return images;
    }

    protected void loadTileSet(TiledMap map, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("tileset")) {
            String name = element.get("name", null);
            int firstgid = element.getIntAttribute("firstgid", 1);
            int tilewidth = element.getIntAttribute("tilewidth", 0);
            int tileheight = element.getIntAttribute("tileheight", 0);
            int spacing = element.getIntAttribute("spacing", 0);
            int margin = element.getIntAttribute("margin", 0);
            String source = element.getAttribute("source", null);
            String imageSource = "";
            int imageWidth = 0;
            int imageHeight = 0;
            FileHandle image = null;
            if (source != null) {
                FileHandle tsx = TmxMapLoader.getRelativeFileHandle(tmxFile, source);
                try {
                    element = this.xml.parse(tsx);
                    name = element.get("name", null);
                    tilewidth = element.getIntAttribute("tilewidth", 0);
                    tileheight = element.getIntAttribute("tileheight", 0);
                    spacing = element.getIntAttribute("spacing", 0);
                    margin = element.getIntAttribute("margin", 0);
                    imageSource = element.getChildByName("image").getAttribute("source");
                    imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
                    imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
                    image = TmxMapLoader.getRelativeFileHandle(tsx, imageSource);
                }
                catch (IOException e) {
                    throw new GdxRuntimeException("Error parsing external tileset.");
                }
            } else {
                imageSource = element.getChildByName("image").getAttribute("source");
                imageWidth = element.getChildByName("image").getIntAttribute("width", 0);
                imageHeight = element.getChildByName("image").getIntAttribute("height", 0);
                image = TmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
            }
            TextureRegion texture = imageResolver.getImage(image.path());
            TiledMapTileSet tileset = new TiledMapTileSet();
            MapProperties props = tileset.getProperties();
            tileset.setName(name);
            props.put("firstgid", firstgid);
            props.put("imagesource", imageSource);
            props.put("imagewidth", imageWidth);
            props.put("imageheight", imageHeight);
            props.put("tilewidth", tilewidth);
            props.put("tileheight", tileheight);
            props.put("margin", margin);
            props.put("spacing", spacing);
            int stopWidth = texture.getRegionWidth() - tilewidth;
            int stopHeight = texture.getRegionHeight() - tileheight;
            int id = firstgid;
            for (int y = margin; y <= stopHeight; y += tileheight + spacing) {
                for (int x = margin; x <= stopWidth; x += tilewidth + spacing) {
                    TextureRegion tileRegion = new TextureRegion(texture, x, y, tilewidth, tileheight);
                    if (!this.yUp) {
                        tileRegion.flip(false, true);
                    }
                    StaticTiledMapTile tile = new StaticTiledMapTile(tileRegion);
                    tile.setId(id);
                    tileset.putTile(id++, tile);
                }
            }
            Array<XmlReader.Element> tileElements = element.getChildrenByName("tile");
            for (XmlReader.Element tileElement : tileElements) {
                XmlReader.Element properties;
                String probability;
                int localtid = tileElement.getIntAttribute("id", 0);
                TiledMapTile tile = tileset.getTile(firstgid + localtid);
                if (tile == null) continue;
                String terrain = tileElement.getAttribute("terrain", null);
                if (terrain != null) {
                    tile.getProperties().put("terrain", terrain);
                }
                if ((probability = tileElement.getAttribute("probability", null)) != null) {
                    tile.getProperties().put("probability", probability);
                }
                if ((properties = tileElement.getChildByName("properties")) == null) continue;
                this.loadProperties(tile.getProperties(), properties);
            }
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(tileset.getProperties(), properties);
            }
            map.getTileSets().addTileSet(tileset);
        }
    }

    protected void loadTileLayer(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            XmlReader.Element properties;
            String name = element.getAttribute("name", null);
            int width = element.getIntAttribute("width", 0);
            int height = element.getIntAttribute("height", 0);
            int tileWidth = element.getParent().getIntAttribute("tilewidth", 0);
            int tileHeight = element.getParent().getIntAttribute("tileheight", 0);
            boolean visible = element.getIntAttribute("visible", 1) == 1;
            float opacity = element.getFloatAttribute("opacity", 1.0f);
            TiledMapTileLayer layer = new TiledMapTileLayer(width, height, tileWidth, tileHeight);
            layer.setVisible(visible);
            layer.setOpacity(opacity);
            layer.setName(name);
            TiledMapTileSets tilesets = map.getTileSets();
            XmlReader.Element data = element.getChildByName("data");
            String encoding = data.getAttribute("encoding", null);
            String compression = data.getAttribute("compression", null);
            if (encoding == null) {
                throw new GdxRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
            }
            if (encoding.equals("csv")) {
                String[] array = data.getText().split(",");
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int id = (int)Long.parseLong(array[y * width + x].trim());
                        boolean flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                        boolean flipVertically = (id & 0x40000000) != 0;
                        boolean flipDiagonally = (id & 0x20000000) != 0;
                        tilesets.getTile(id &= 0x1FFFFFFF);
                        TiledMapTile tile = tilesets.getTile(id);
                        if (tile == null) continue;
                        TiledMapTileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                        cell.setTile(tile);
                        layer.setCell(x, this.yUp ? height - 1 - y : y, cell);
                    }
                }
            } else if (encoding.equals("base64")) {
                byte[] bytes = Base64Coder.decode(data.getText());
                if (compression == null) {
                    int read = 0;
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int id;
                            boolean flipHorizontally = ((id = TmxMapLoader.unsignedByteToInt(bytes[read++]) | TmxMapLoader.unsignedByteToInt(bytes[read++]) << 8 | TmxMapLoader.unsignedByteToInt(bytes[read++]) << 16 | TmxMapLoader.unsignedByteToInt(bytes[read++]) << 24) & Integer.MIN_VALUE) != 0;
                            boolean flipVertically = (id & 0x40000000) != 0;
                            boolean flipDiagonally = (id & 0x20000000) != 0;
                            tilesets.getTile(id &= 0x1FFFFFFF);
                            TiledMapTile tile = tilesets.getTile(id);
                            if (tile == null) continue;
                            TiledMapTileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                            cell.setTile(tile);
                            layer.setCell(x, this.yUp ? height - 1 - y : y, cell);
                        }
                    }
                } else if (compression.equals("gzip")) {
                    GZIPInputStream GZIS = null;
                    try {
                        GZIS = new GZIPInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    }
                    catch (IOException e) {
                        throw new GdxRuntimeException("Error Reading TMX Layer Data - IOException: " + e.getMessage());
                    }
                    byte[] temp = new byte[4];
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            try {
                                GZIS.read(temp, 0, 4);
                                int id = TmxMapLoader.unsignedByteToInt(temp[0]) | TmxMapLoader.unsignedByteToInt(temp[1]) << 8 | TmxMapLoader.unsignedByteToInt(temp[2]) << 16 | TmxMapLoader.unsignedByteToInt(temp[3]) << 24;
                                boolean flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                boolean flipVertically = (id & 0x40000000) != 0;
                                boolean flipDiagonally = (id & 0x20000000) != 0;
                                tilesets.getTile(id &= 0x1FFFFFFF);
                                TiledMapTile tile = tilesets.getTile(id);
                                if (tile == null) continue;
                                TiledMapTileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                                cell.setTile(tile);
                                layer.setCell(x, this.yUp ? height - 1 - y : y, cell);
                                continue;
                            }
                            catch (IOException e) {
                                throw new GdxRuntimeException("Error Reading TMX Layer Data.", e);
                            }
                        }
                    }
                } else if (compression.equals("zlib")) {
                    Inflater zlib = new Inflater();
                    byte[] temp = new byte[4];
                    zlib.setInput(bytes, 0, bytes.length);
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            try {
                                zlib.inflate(temp, 0, 4);
                                int id = TmxMapLoader.unsignedByteToInt(temp[0]) | TmxMapLoader.unsignedByteToInt(temp[1]) << 8 | TmxMapLoader.unsignedByteToInt(temp[2]) << 16 | TmxMapLoader.unsignedByteToInt(temp[3]) << 24;
                                boolean flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                                boolean flipVertically = (id & 0x40000000) != 0;
                                boolean flipDiagonally = (id & 0x20000000) != 0;
                                tilesets.getTile(id &= 0x1FFFFFFF);
                                TiledMapTile tile = tilesets.getTile(id);
                                if (tile == null) continue;
                                TiledMapTileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                                cell.setTile(tile);
                                layer.setCell(x, this.yUp ? height - 1 - y : y, cell);
                                continue;
                            }
                            catch (DataFormatException e) {
                                throw new GdxRuntimeException("Error Reading TMX Layer Data.", e);
                            }
                        }
                    }
                }
            } else {
                throw new GdxRuntimeException("Unrecognised encoding (" + encoding + ") for TMX Layer Data");
            }
            if ((properties = element.getChildByName("properties")) != null) {
                this.loadProperties(layer.getProperties(), properties);
            }
            map.getLayers().add(layer);
        }
    }

    protected void loadObjectGroup(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("objectgroup")) {
            String name = element.getAttribute("name", null);
            MapLayer layer = new MapLayer();
            layer.setName(name);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.getProperties(), properties);
            }
            for (XmlReader.Element objectElement : element.getChildrenByName("object")) {
                this.loadObject(layer, objectElement);
            }
            map.getLayers().add(layer);
        }
    }

    protected void loadObject(MapLayer layer, XmlReader.Element element) {
        if (element.getName().equals("object")) {
            int gid;
            MapObject object = null;
            float scaleX = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileWidth : 1.0f;
            float scaleY = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileHeight : 1.0f;
            float x = (float)element.getIntAttribute("x", 0) * scaleX;
            float y = (float)(this.yUp ? this.mapHeightInPixels - element.getIntAttribute("y", 0) : element.getIntAttribute("y", 0)) * scaleY;
            float width = (float)element.getIntAttribute("width", 0) * scaleX;
            float height = (float)element.getIntAttribute("height", 0) * scaleY;
            if (element.getChildCount() > 0) {
                float[] vertices;
                String[] points;
                XmlReader.Element child = null;
                child = element.getChildByName("polygon");
                if (child != null) {
                    points = child.getAttribute("points").split(" ");
                    vertices = new float[points.length * 2];
                    for (int i = 0; i < points.length; ++i) {
                        String[] point = points[i].split(",");
                        vertices[i * 2] = (float)Integer.parseInt(point[0]) * scaleX;
                        vertices[i * 2 + 1] = (float)Integer.parseInt(point[1]) * scaleY;
                        if (!this.yUp) continue;
                        int n = i * 2 + 1;
                        vertices[n] = vertices[n] * -1.0f;
                    }
                    Polygon polygon = new Polygon(vertices);
                    polygon.setPosition(x, y);
                    object = new PolygonMapObject(polygon);
                } else {
                    child = element.getChildByName("polyline");
                    if (child != null) {
                        points = child.getAttribute("points").split(" ");
                        vertices = new float[points.length * 2];
                        for (int i = 0; i < points.length; ++i) {
                            String[] point = points[i].split(",");
                            vertices[i * 2] = (float)Integer.parseInt(point[0]) * scaleX;
                            vertices[i * 2 + 1] = (float)Integer.parseInt(point[1]) * scaleY;
                            if (!this.yUp) continue;
                            int n = i * 2 + 1;
                            vertices[n] = vertices[n] * -1.0f;
                        }
                        Polyline polyline = new Polyline(vertices);
                        polyline.setPosition(x, y);
                        object = new PolylineMapObject(polyline);
                    } else {
                        child = element.getChildByName("ellipse");
                        if (child != null) {
                            object = new EllipseMapObject(x, this.yUp ? y - height : y, width, height);
                        }
                    }
                }
            }
            if (object == null) {
                object = new RectangleMapObject(x, this.yUp ? y - height : y, width, height);
            }
            object.setName(element.getAttribute("name", null));
            String type = element.getAttribute("type", null);
            if (type != null) {
                object.getProperties().put("type", type);
            }
            if ((gid = element.getIntAttribute("gid", -1)) != -1) {
                object.getProperties().put("gid", gid);
            }
            object.getProperties().put("x", Float.valueOf(x * scaleX));
            object.getProperties().put("y", Float.valueOf((this.yUp ? y - height : y) * scaleY));
            object.setVisible(element.getIntAttribute("visible", 1) == 1);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(object.getProperties(), properties);
            }
            layer.getObjects().add(object);
        }
    }

    protected void loadProperties(MapProperties properties, XmlReader.Element element) {
        if (element.getName().equals("properties")) {
            for (XmlReader.Element property : element.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                if (value == null) {
                    value = property.getText();
                }
                properties.put(name, value);
            }
        }
    }

    protected TiledMapTileLayer.Cell createTileLayerCell(boolean flipHorizontally, boolean flipVertically, boolean flipDiagonally) {
        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
        if (flipDiagonally) {
            if (flipHorizontally && flipVertically) {
                cell.setFlipHorizontally(true);
                cell.setRotation(this.yUp ? 3 : 1);
            } else if (flipHorizontally) {
                cell.setRotation(this.yUp ? 3 : 1);
            } else if (flipVertically) {
                cell.setRotation(this.yUp ? 1 : 3);
            } else {
                cell.setFlipVertically(true);
                cell.setRotation(this.yUp ? 3 : 1);
            }
        } else {
            cell.setFlipHorizontally(flipHorizontally);
            cell.setFlipVertically(flipVertically);
        }
        return cell;
    }

    protected static FileHandle getRelativeFileHandle(FileHandle file, String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "\\/");
        FileHandle result = file.parent();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                result = result.parent();
                continue;
            }
            result = result.child(token);
        }
        return result;
    }

    protected static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
        public boolean yUp = true;
        public boolean generateMipMaps = false;
        public Texture.TextureFilter textureMinFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter textureMagFilter = Texture.TextureFilter.Nearest;
        public boolean convertObjectToTileSpace = false;
    }
}

