/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class VertexArray
implements VertexData {
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    final ByteBuffer byteBuffer;
    boolean isBound = false;

    public VertexArray(int numVertices, VertexAttribute ... attributes) {
        this(numVertices, new VertexAttributes(attributes));
    }

    public VertexArray(int numVertices, VertexAttributes attributes) {
        this.attributes = attributes;
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(this.attributes.vertexSize * numVertices);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
    }

    @Override
    public FloatBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getNumVertices() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public int getNumMaxVertices() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    @Override
    public void setVertices(float[] vertices, int offset, int count) {
        BufferUtils.copy(vertices, this.byteBuffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
    }

    @Override
    public void updateVertices(int targetOffset, float[] vertices, int sourceOffset, int count) {
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        BufferUtils.copy(vertices, sourceOffset, count, (Buffer)this.byteBuffer);
        this.byteBuffer.position(pos);
    }

    @Override
    public void bind() {
        GL10 gl = Gdx.gl10;
        int textureUnit = 0;
        int numAttributes = this.attributes.size();
        this.byteBuffer.limit(this.buffer.limit() * 4);
        block6: for (int i = 0; i < numAttributes; ++i) {
            VertexAttribute attribute = this.attributes.get(i);
            switch (attribute.usage) {
                case 1: {
                    this.byteBuffer.position(attribute.offset);
                    gl.glEnableClientState(32884);
                    gl.glVertexPointer(attribute.numComponents, 5126, this.attributes.vertexSize, this.byteBuffer);
                    continue block6;
                }
                case 2: 
                case 4: {
                    int colorType = 5126;
                    if (attribute.usage == 4) {
                        colorType = 5121;
                    }
                    this.byteBuffer.position(attribute.offset);
                    gl.glEnableClientState(32886);
                    gl.glColorPointer(attribute.numComponents, colorType, this.attributes.vertexSize, this.byteBuffer);
                    continue block6;
                }
                case 8: {
                    this.byteBuffer.position(attribute.offset);
                    gl.glEnableClientState(32885);
                    gl.glNormalPointer(5126, this.attributes.vertexSize, this.byteBuffer);
                    continue block6;
                }
                case 16: {
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glEnableClientState(32888);
                    this.byteBuffer.position(attribute.offset);
                    gl.glTexCoordPointer(attribute.numComponents, 5126, this.attributes.vertexSize, this.byteBuffer);
                    ++textureUnit;
                    continue block6;
                }
            }
        }
        this.isBound = true;
    }

    @Override
    public void unbind() {
        GL10 gl = Gdx.gl10;
        int textureUnit = 0;
        int numAttributes = this.attributes.size();
        block6: for (int i = 0; i < numAttributes; ++i) {
            VertexAttribute attribute = this.attributes.get(i);
            switch (attribute.usage) {
                case 1: {
                    continue block6;
                }
                case 2: 
                case 4: {
                    gl.glDisableClientState(32886);
                    continue block6;
                }
                case 8: {
                    gl.glDisableClientState(32885);
                    continue block6;
                }
                case 16: {
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glDisableClientState(32888);
                    ++textureUnit;
                    continue block6;
                }
            }
        }
        this.byteBuffer.position(0);
        this.isBound = false;
    }

    @Override
    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    @Override
    public void bind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        int numAttributes = this.attributes.size();
        this.byteBuffer.limit(this.buffer.limit() * 4);
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = shader.getAttributeLocation(attribute.alias);
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                this.byteBuffer.position(attribute.offset);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, (Buffer)this.byteBuffer);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, (Buffer)this.byteBuffer);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = locations[i];
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                this.byteBuffer.position(attribute.offset);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, (Buffer)this.byteBuffer);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, (Buffer)this.byteBuffer);
            }
        }
        this.isBound = true;
    }

    @Override
    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    @Override
    public void unbind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        int numAttributes = this.attributes.size();
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                shader.disableVertexAttribute(this.attributes.get((int)i).alias);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                int location = locations[i];
                if (location < 0) continue;
                shader.disableVertexAttribute(location);
            }
        }
        this.isBound = false;
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }
}

