/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;

public class Node {
    public String id;
    public Node parent;
    public final Array<Node> children = new Array(2);
    public boolean isAnimated;
    public final Vector3 translation = new Vector3();
    public final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
    public final Matrix4 localTransform = new Matrix4();
    public final Matrix4 globalTransform = new Matrix4();
    public Array<NodePart> parts = new Array(2);

    public Matrix4 calculateLocalTransform() {
        if (!this.isAnimated) {
            this.localTransform.idt();
            this.localTransform.translate(this.translation);
            this.localTransform.rotate(this.rotation);
            this.localTransform.scale(this.scale.x, this.scale.y, this.scale.z);
        }
        return this.localTransform;
    }

    public Matrix4 calculateWorldTransform() {
        if (this.parent == null) {
            this.globalTransform.set(this.localTransform);
        } else {
            this.globalTransform.set(this.parent.globalTransform).mul(this.localTransform);
        }
        return this.globalTransform;
    }

    public void calculateTransforms(boolean recursive) {
        this.calculateLocalTransform();
        this.calculateWorldTransform();
        if (recursive) {
            for (Node child : this.children) {
                child.calculateTransforms(true);
            }
        }
    }

    public void calculateBoneTransforms(boolean recursive) {
        for (NodePart part : this.parts) {
            if (part.invBoneBindTransforms == null || part.bones == null || part.invBoneBindTransforms.size != part.bones.length) continue;
            int n = part.invBoneBindTransforms.size;
            for (int i = 0; i < n; ++i) {
                part.bones[i].set(((Node[])part.invBoneBindTransforms.keys)[i].globalTransform).mul(((Matrix4[])part.invBoneBindTransforms.values)[i]);
            }
        }
        if (recursive) {
            for (Node child : this.children) {
                child.calculateBoneTransforms(true);
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox out) {
        out.inf();
        return this.extendBoundingBox(out);
    }

    public BoundingBox calculateBoundingBox(BoundingBox out, boolean transform) {
        out.inf();
        return this.extendBoundingBox(out, transform);
    }

    public BoundingBox extendBoundingBox(BoundingBox out) {
        return this.extendBoundingBox(out, true);
    }

    public BoundingBox extendBoundingBox(BoundingBox out, boolean transform) {
        int partCount = this.parts.size;
        for (int i = 0; i < partCount; ++i) {
            MeshPart meshPart = this.parts.get((int)i).meshPart;
            if (transform) {
                meshPart.mesh.extendBoundingBox(out, meshPart.indexOffset, meshPart.numVertices, this.globalTransform);
                continue;
            }
            meshPart.mesh.extendBoundingBox(out, meshPart.indexOffset, meshPart.numVertices);
        }
        int childCount = this.children.size;
        for (int i = 0; i < childCount; ++i) {
            this.children.get(i).extendBoundingBox(out);
        }
        return out;
    }

    public Node getChild(String id, boolean recursive, boolean ignoreCase) {
        return Node.getNode(this.children, id, recursive, ignoreCase);
    }

    public static Node getNode(Array<Node> nodes, String id, boolean recursive, boolean ignoreCase) {
        Node node;
        int i;
        int n = nodes.size;
        if (ignoreCase) {
            for (i = 0; i < n; ++i) {
                node = nodes.get(i);
                if (!node.id.equalsIgnoreCase(id)) continue;
                return node;
            }
        } else {
            for (i = 0; i < n; ++i) {
                node = nodes.get(i);
                if (!node.id.equals(id)) continue;
                return node;
            }
        }
        if (recursive) {
            for (i = 0; i < n; ++i) {
                node = Node.getNode(nodes.get((int)i).children, id, true, ignoreCase);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

