/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.stages;

import com.badlogic.gdx.math.Vector2;
import walnoot.sharkgame.entities.BoatEntity;
import walnoot.sharkgame.entities.BulletEntity;
import walnoot.sharkgame.entities.SharkEntity;
import walnoot.sharkgame.screens.GameScreen;
import walnoot.sharkgame.stages.BoatStage;

public class ShootStage
extends BoatStage {
    private static final float SHOOT_DIST_SQ = 4.0f;
    private static final int VOLLEY_TIME = 120;
    private static final int BURST_TIME = 30;
    private static final int TICKS_PER_BULLET = 3;
    private static final Vector2 TMP = new Vector2();
    private int bulletTimer = 0;
    private int timer = 0;
    private final GameScreen screen;

    public ShootStage(BoatEntity boat, SharkEntity shark, GameScreen screen) {
        super(boat, shark);
        this.screen = screen;
    }

    @Override
    public BoatStage update() {
        if (TMP.set(this.boat.getX(), 0.0f).sub(this.shark.getPosition()).len2() < 4.0f) {
            return null;
        }
        if (this.bulletTimer++ == 120) {
            this.bulletTimer = 0;
            this.timer = 0;
        }
        ++this.timer;
        if (this.timer % 3 == 0 && this.bulletTimer < 30) {
            TMP.set(this.shark.getPosition()).sub(this.boat.getX(), 0.0f).nor();
            this.screen.addEntity(new BulletEntity(this.boat.getX(), 0.0f, ShootStage.TMP.x, ShootStage.TMP.y, this.shark));
        }
        return null;
    }

    @Override
    public float getSpeed() {
        return 1.0f;
    }
}

