/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.stages;

import com.badlogic.gdx.math.MathUtils;
import walnoot.sharkgame.Announcement;
import walnoot.sharkgame.entities.BoatEntity;
import walnoot.sharkgame.entities.ExplosionEntity;
import walnoot.sharkgame.entities.SharkEntity;
import walnoot.sharkgame.screens.GameScreen;
import walnoot.sharkgame.stages.BoatStage;

public class EpicEndingStage
extends BoatStage {
    private static final int START_TIME = 120;
    private static final int TIME_BETWEEN_EXPLOSIONS = 7;
    private int startTimer = 120;
    private final GameScreen screen;
    private boolean exploding;
    private int explodeTimer = 7;

    public EpicEndingStage(BoatEntity boat, SharkEntity shark, GameScreen screen) {
        super(boat, shark);
        this.screen = screen;
        screen.showAnnouncement(Announcement.EXPLAIN_ENDING);
    }

    @Override
    public BoatStage update() {
        if (this.exploding) {
            int i = 0;
            while (i < 25) {
                this.screen.addEntity(new ExplosionEntity(this.boat.getX() + MathUtils.random(-1.0f, 1.0f), MathUtils.random(-1.0f, 1.0f)));
                ++i;
            }
            this.boat.remove();
        } else if (this.shark.getPosition().x > this.boat.getX() - 1.0f && this.shark.getPosition().x < this.boat.getX() + 1.0f && this.shark.getPosition().y > 0.0f) {
            this.screen.showAnnouncement(Announcement.ENDING);
            this.exploding = true;
        }
        return null;
    }

    @Override
    public float getSpeed() {
        return 0.0f;
    }
}

