/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Array;
import walnoot.sharkgame.Announcement;
import walnoot.sharkgame.InputHandler;
import walnoot.sharkgame.SharkGame;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.BoatEntity;
import walnoot.sharkgame.entities.Entity;
import walnoot.sharkgame.entities.FishEntity;
import walnoot.sharkgame.entities.SharkEntity;
import walnoot.sharkgame.screens.UpdateScreen;

public class GameScreen
extends UpdateScreen {
    private static final int NUM_RAYS = 20;
    private static final int FISH_SPAWN_TIME = 60;
    private static final float INTRO_X = -10.0f;
    private static final int INTRO_ANIMATION_TIME = 120;
    private static final int ANNOUNCEMENT_TIME = 300;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private Array<Entity> entities = new Array();
    private boolean sortEntities;
    private Mesh skyMesh;
    private Mesh seaMesh;
    private Mesh lightMesh;
    private float[] skyVertices;
    private float[] seaVertices;
    private float[] lightVertices;
    private float[] rayPositions;
    private float[] rayHeights;
    private World world;
    private Box2DDebugRenderer renderer;
    private SharkEntity shark;
    int fishTimer = 60;
    private Color bottomSeaColor;
    private Sprite logoSprite;
    private int introTimer = 0;
    private boolean stopIntro = false;
    private Stage stage;
    private Label announcement;
    private int announcementTimer = 0;
    private Array<Announcement> shownTips = new Array();
    private Table healthTable;
    private Slider sharkSlider;
    private Slider boatSlider;

    public GameScreen(SharkGame game) {
        super(game);
        this.camera = new OrthographicCamera(2.0f * (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight(), 2.0f);
        this.camera.position.x = -10.0f;
        this.camera.zoom = 4.0f;
        this.batch = new SpriteBatch();
        this.createBackground();
        this.world = new World(new Vector2(), true);
        this.renderer = new Box2DDebugRenderer();
        this.shark = new SharkEntity(this.world, this);
        this.addEntity(this.shark);
        this.addEntity(new BoatEntity(this.shark, this));
        this.logoSprite = new Sprite(Util.LOGO);
        this.logoSprite.setSize(this.camera.zoom * 2.0f, this.camera.zoom);
        this.logoSprite.setPosition(-this.camera.zoom + -10.0f, 0.0f);
    }

    private void setupUI() {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("Chunkfive.ttf"));
        BitmapFont font = generator.generateFont(Gdx.graphics.getHeight() / 16);
        this.stage = new Stage();
        Table table = new Table();
        table.left().bottom().pad(8.0f).setFillParent(true);
        this.stage.addActor(table);
        this.announcement = new Label(null, new Label.LabelStyle(font, Util.getColor("5ce753ff")));
        this.showAnnouncement(Announcement.MENU);
        table.add(this.announcement);
        NinePatch backgroundPatch = new NinePatch(Util.HEALTH_BACKGROUND, 15, 15, 15, 15);
        NinePatch sliderPatch = new NinePatch(backgroundPatch);
        sliderPatch.setColor(Color.RED);
        NinePatchDrawable sliderNinePatch = new NinePatchDrawable(sliderPatch);
        NinePatchDrawable backgroundNinePatch = new NinePatchDrawable(backgroundPatch);
        this.healthTable = new Table();
        this.healthTable.setVisible(false);
        this.healthTable.top().pad(4.0f).setFillParent(true);
        this.stage.addActor(this.healthTable);
        Slider.SliderStyle sharkStyle = new Slider.SliderStyle(backgroundNinePatch, null);
        sharkStyle.knobBefore = sliderNinePatch;
        Slider.SliderStyle boatStyle = new Slider.SliderStyle(sharkStyle);
        boatStyle.knobBefore = null;
        boatStyle.knobAfter = sliderNinePatch;
        this.sharkSlider = new Slider(0.0f, 1.0f, 1.0E-4f, false, sharkStyle);
        this.sharkSlider.setValue(1.0f);
        this.healthTable.add(this.sharkSlider).expandX().fillX();
        this.boatSlider = new Slider(0.0f, 1.0f, 1.0E-4f, false, boatStyle);
        this.boatSlider.setValue(0.0f);
        this.healthTable.add(this.boatSlider).expandX().fillX();
    }

    private void createBackground() {
        this.skyMesh = this.getMesh();
        this.skyVertices = this.getVertices("00c6ffff", "a8ecffff");
        this.bottomSeaColor = Util.getColor("071b30ff");
        Color topSeaColor = Util.getColor("12437cff");
        this.seaMesh = this.getMesh();
        this.seaVertices = this.getVertices(topSeaColor, this.bottomSeaColor);
        this.lightMesh = this.getMesh();
        this.lightVertices = this.getVertices("ffffff99", "ffffff00");
        this.rayPositions = new float[20];
        this.rayHeights = new float[20];
        int i = 0;
        while (i < 20) {
            this.rayPositions[i] = MathUtils.random();
            this.rayHeights[i] = MathUtils.random(2.5f, 3.5f);
            ++i;
        }
    }

    private Mesh getMesh() {
        return new Mesh(false, 4, 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"));
    }

    private float[] getVertices(String topColor, String bottomColor) {
        return this.getVertices(Util.getColor(topColor), Util.getColor(bottomColor));
    }

    private float[] getVertices(Color topColor, Color bottomColor) {
        float top = topColor.toFloatBits();
        float bottom = bottomColor.toFloatBits();
        return new float[]{0.0f, 0.0f, bottom, 0.0f, 0.0f, bottom, 0.0f, 0.0f, top, 0.0f, 0.0f, top};
    }

    @Override
    protected void render() {
        if (this.sortEntities) {
            this.entities.sort();
            this.sortEntities = false;
        }
        Gdx.gl.glClearColor(this.bottomSeaColor.r, this.bottomSeaColor.g, this.bottomSeaColor.b, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        Gdx.gl10.glDisable(3553);
        Gdx.gl10.glEnable(3042);
        this.renderBackground();
        Gdx.gl10.glEnable(3553);
        for (Entity e : this.entities) {
            e.render(this.batch);
        }
        if (this.introTimer < 120) {
            this.logoSprite.draw(this.batch);
        }
        this.batch.end();
        Gdx.gl10.glEnable(3042);
        this.renderRays(false);
        this.stage.draw();
        Table.drawDebug(this.stage);
    }

    private void renderBackground() {
        float screenWidth = this.camera.viewportWidth * this.camera.zoom;
        float screenHeight = this.camera.viewportHeight * this.camera.zoom;
        float x = this.camera.position.x;
        this.setVertices(this.seaMesh, this.seaVertices, -screenWidth * 0.5f + x, -screenHeight * 0.5f, screenWidth, screenHeight * 0.5f, 0.0f);
        this.setVertices(this.skyMesh, this.skyVertices, -screenWidth * 0.5f + x, 0.0f, screenWidth, screenHeight * 0.5f, 0.0f);
        this.skyMesh.render(6);
        this.seaMesh.render(6);
        this.renderRays(true);
    }

    private void renderRays(boolean even) {
        float screenWidth = this.camera.viewportWidth * this.camera.zoom;
        float x = this.camera.position.x;
        int i = (int)(x - screenWidth / 2.0f) - 1;
        while (i < (int)(x + screenWidth / 2.0f) + 2) {
            if (i % 2 != (even ? 0 : 1)) {
                int rayIndex = Util.wrap(i, this.rayPositions.length);
                float height = this.rayHeights[rayIndex];
                this.setVertices(this.lightMesh, this.lightVertices, -1.0f + this.rayPositions[rayIndex] + (float)i, -height, 0.5f, height, 0.25f * height);
                this.lightMesh.render(6);
            }
            ++i;
        }
    }

    private void setVertices(Mesh mesh, float[] vertices, float x, float y, float width, float height, float shearX) {
        vertices[0] = x;
        vertices[1] = y;
        vertices[3] = x + width;
        vertices[4] = y;
        vertices[6] = x + width + shearX;
        vertices[7] = y + height;
        vertices[9] = x + shearX;
        vertices[10] = y + height;
        mesh.setVertices(vertices);
    }

    @Override
    public void update() {
        if (this.introTimer != 0) {
            this.updateGame();
        } else if (InputHandler.instance.start.isJustPressed()) {
            this.stopIntro = true;
            this.announcement.setText(null);
        }
        if (this.stopIntro) {
            ++this.introTimer;
        }
        if (this.shark.removed) {
            this.announcement.setText("GAME OVER! PRESS SPACE TO RETRY");
            if (InputHandler.instance.start.isJustPressed()) {
                this.game.setScreen(new GameScreen(this.game));
            }
        }
        if (this.announcementTimer-- == 0) {
            this.announcement.setText(null);
        }
    }

    private void updateGame() {
        if (this.fishTimer-- == 0) {
            this.fishTimer = 60;
            float x = this.camera.position.x;
            this.addEntity(new FishEntity(this.shark, x += MathUtils.randomBoolean() ? this.camera.viewportWidth * this.camera.zoom : -this.camera.viewportWidth * this.camera.zoom, MathUtils.random(-4.0f, -1.0f), MathUtils.randomBoolean() ? -1.0f : 1.0f));
        }
        if (!this.shark.removed) {
            this.world.step(0.016666668f, 6, 2);
        }
        int i = 0;
        while (i < this.entities.size) {
            this.entities.get(i).update();
            if (this.entities.get((int)i).removed) {
                this.entities.removeIndex(i);
                --i;
            }
            ++i;
        }
        float targetX = this.shark.getPosition().x + this.shark.getBody().getLinearVelocity().x * 0.7f;
        this.camera.position.x += (targetX - this.camera.position.x) * 0.1f;
        float targetY = Math.min(0.0f, this.shark.getPosition().y);
        this.camera.position.y += (targetY - this.camera.position.y) * 0.4f;
        this.camera.update();
    }

    public void showAnnouncement(Announcement announcement) {
        if (!this.shownTips.contains(announcement, true)) {
            this.announcement.setText(announcement.text);
        }
        this.announcementTimer = 300;
        this.shownTips.add(announcement);
    }

    public void setSharkHealthSlider(float value) {
        this.sharkSlider.setValue(value);
    }

    public void setBoathHealthSlider(float value) {
        this.boatSlider.setValue(1.0f - value);
    }

    public void addEntity(Entity e) {
        this.sortEntities = true;
        this.entities.add(e);
    }

    public Array<Entity> getEntities() {
        return this.entities;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void showHealthTable() {
        this.healthTable.setVisible(true);
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.update();
        this.setupUI();
    }
}

