/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import walnoot.sharkgame.InputHandler;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.Entity;
import walnoot.sharkgame.screens.GameScreen;

public class SharkEntity
extends Entity {
    private static final float FRICTION = 1.0f;
    private static final float TURN_SPEED = 4000.0f;
    private static final float FORCE = 5.0f;
    private static final int FLIP_TIME = 15;
    private static final float ANIMATION_THRESHOLD = 1.0f;
    private Sprite sprite;
    private Body body;
    private Vector2 prevPos = new Vector2();
    private Vector2 force = new Vector2();
    private Vector2 gravity = new Vector2(0.0f, -6.0f);
    private float direction;
    private float angle;
    private int flipTimer = 0;
    private float animationTimer = 0.0f;
    private Vector2 tmp = new Vector2();
    private TextureRegion[] animation;
    private int animIndex = 0;
    private float health = 1.0f;
    private final GameScreen screen;

    public SharkEntity(World world, GameScreen gameScreen) {
        this.screen = gameScreen;
        Texture texture = Util.SHARK;
        this.animation = new TextureRegion[]{new TextureRegion(texture, 0, 0, 512, 256), new TextureRegion(texture, 0, 256, 512, 256)};
        this.sprite = new Sprite(this.animation[0]);
        this.sprite.setSize(2.0f, 1.0f);
        this.sprite.setOrigin(1.0f, 0.5f);
        this.body = world.createBody(Util.getBodyDef());
        this.body.setTransform(0.0f, -2.0f, 0.0f);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(1.0f, 0.3f);
        this.body.createFixture(Util.getFixtureDef(shape));
        shape.dispose();
        this.body.applyForceToCenter(new Vector2(60.0f, 0.0f), true);
    }

    @Override
    public void render(SpriteBatch batch) {
        this.sprite.setPosition(this.body.getPosition().x - this.sprite.getOriginX(), this.body.getPosition().y - this.sprite.getOriginY());
        this.sprite.draw(batch);
    }

    @Override
    public void update() {
        this.flipTimer = this.prevPos.x > this.body.getPosition().x ? ++this.flipTimer : --this.flipTimer;
        this.flipTimer = MathUtils.clamp(this.flipTimer, 0, 15);
        this.sprite.setScale(1.0f, MathUtils.cos((float)this.flipTimer * (float)Math.PI / 15.0f));
        this.direction = Math.signum(this.prevPos.x - this.body.getPosition().x);
        this.angle = this.prevPos.sub(this.body.getPosition()).scl(-1.0f).angle();
        this.sprite.setRotation(this.angle);
        this.body.setTransform(this.body.getPosition(), this.angle * ((float)Math.PI / 180));
        this.prevPos.set(this.body.getPosition());
        if (this.body.getPosition().y < 0.0f) {
            boolean moveLeft = InputHandler.instance.moveLeft.isPressed();
            boolean moveRight = InputHandler.instance.moveRight.isPressed();
            if (Gdx.input.isButtonPressed(0)) {
                if (Gdx.input.getX() < Gdx.graphics.getWidth() / 2) {
                    moveLeft = true;
                } else {
                    moveRight = true;
                }
            }
            if (moveLeft) {
                this.angle += 66.66667f;
            }
            if (moveRight) {
                this.angle -= 66.66667f;
            }
            this.force.set(1.0f, 0.0f).rotate(this.angle).scl(5.0f);
            this.body.setLinearDamping(1.0f);
            this.body.applyForceToCenter(this.force, true);
        } else {
            this.body.setLinearDamping(0.0f);
            this.body.applyForceToCenter(this.gravity, true);
        }
        if (this.body.getPosition().y < 0.0f) {
            this.animationTimer += this.body.getLinearVelocity().len() * 0.016666668f;
        }
        while (this.animationTimer > 1.0f) {
            this.animationTimer -= 1.0f;
            this.sprite.setRegion(this.animation[this.animIndex++ % this.animation.length]);
        }
        Util.setDepthColor(this.sprite, this.body.getPosition().y);
    }

    public void damage(float damage) {
        this.health -= damage;
        this.screen.setSharkHealthSlider(this.health);
        if (this.health <= 0.0f) {
            this.remove();
        }
    }

    public Vector2 getMouthPosition() {
        return this.tmp.set(0.75f, 0.0f).rotate(this.angle).add(this.getPosition());
    }

    public Vector2 getPosition() {
        return this.body.getPosition();
    }

    public float getDirection() {
        return this.direction;
    }

    public Body getBody() {
        return this.body;
    }
}

