/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.entities;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.Entity;
import walnoot.sharkgame.entities.SharkEntity;

public class FishEntity
extends Entity {
    private static final float SPEED = 2.0f;
    private static final float EAT_DIST_SQ = 0.25f;
    private static final float SPOOK_DIST_SQ = 1.0f;
    private final Sprite sprite;
    private final SharkEntity shark;
    private final Vector2 position;
    private float speed;
    private boolean spooked;

    public FishEntity(SharkEntity shark, float x, float y, float speed) {
        this.shark = shark;
        this.speed = speed;
        this.sprite = new Sprite(Util.FISH);
        this.sprite.setSize(0.5f, 0.25f);
        this.sprite.setOrigin(0.25f, 0.125f);
        if (speed < 0.0f) {
            this.sprite.flip(true, false);
        }
        this.position = new Vector2(x, y);
    }

    @Override
    public void render(SpriteBatch batch) {
        this.sprite.setPosition(this.position.x - this.sprite.getOriginX(), this.position.y - this.sprite.getOriginY());
        this.sprite.draw(batch);
    }

    @Override
    public void update() {
        this.position.x += this.speed * 0.016666668f * 2.0f;
        if (Util.TMP.set(this.position).sub(this.shark.getMouthPosition()).len2() < 0.25f) {
            this.remove();
        }
        if (Util.TMP.set(this.position).sub(this.shark.getPosition()).scl(0.25f, 1.0f).len2() < 1.0f && !this.spooked) {
            this.spooked = true;
            this.speed *= 2.0f;
            if (this.shark.getPosition().x < this.position.x) {
                if (this.speed < 0.0f) {
                    this.speed = -this.speed;
                    this.sprite.flip(true, false);
                }
            } else if (this.speed > 0.0f) {
                this.speed = -this.speed;
                this.sprite.flip(true, false);
            }
        }
        Util.setDepthColor(this.sprite, this.position.y);
    }

    @Override
    public int getRenderLayer() {
        return 1;
    }
}

