/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.Entity;

public class ExplosionEntity
extends Entity {
    private static final int COLOR_CHANGE_TIME = 60;
    private static final int DESPAWN_TIME = 90;
    private static final Color START_COLOR = Util.getColor("eecc11ff");
    private static final Color END_COLOR = Color.BLACK;
    private Sprite sprite;
    private int timer;
    private Color color = new Color();

    public ExplosionEntity(float x, float y) {
        this.sprite = new Sprite(Util.BULLET);
        this.sprite.setSize(1.0f, 1.0f);
        this.sprite.setOrigin(0.5f, 0.5f);
        this.sprite.setPosition(x - this.sprite.getOriginX(), y - this.sprite.getOriginY());
        this.sprite.setColor(START_COLOR);
    }

    @Override
    public void render(SpriteBatch batch) {
        this.sprite.draw(batch);
    }

    @Override
    public void update() {
        if (this.timer <= 60) {
            this.color.set(START_COLOR).lerp(END_COLOR, (float)this.timer / 60.0f);
            this.sprite.setColor(this.color);
        }
        if (this.timer == 90) {
            this.remove();
        }
        ++this.timer;
    }
}

