/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.Entity;
import walnoot.sharkgame.entities.SharkEntity;

public class BulletEntity
extends Entity {
    private static final Color COLOR = Util.getColor("ffd42aff");
    private static final float DAMAGE = 0.025f;
    private static final float SPEED = 5.0f;
    private static final Vector2 TMP = new Vector2();
    private static final int TRAIL_SIZE = 10;
    private static final int DESPAWN_TIME = 300;
    private final Vector2 position = new Vector2();
    private final Vector2 direction = new Vector2();
    private Sprite sprite;
    private final SharkEntity shark;
    private int timer;

    public BulletEntity(float x, float y, float dirX, float dirY, SharkEntity shark) {
        this.shark = shark;
        this.position.set(x, y);
        this.direction.set(dirX, dirY);
        this.sprite = new Sprite(Util.BULLET);
        this.sprite.setSize(0.125f, 0.125f);
        this.sprite.setOrigin(0.0625f, 0.0625f);
        this.sprite.setPosition(x, y);
        this.sprite.setColor(COLOR);
    }

    @Override
    public void render(SpriteBatch batch) {
        int i = 0;
        while (i < 10) {
            TMP.set(this.direction).scl(0.0625f * (float)i).add(this.position);
            this.sprite.setColor(BulletEntity.COLOR.r, BulletEntity.COLOR.g, BulletEntity.COLOR.b, (float)i / 10.0f);
            this.sprite.setPosition(BulletEntity.TMP.x, BulletEntity.TMP.y);
            this.sprite.draw(batch);
            ++i;
        }
    }

    @Override
    public void update() {
        this.position.add(this.direction.x * 5.0f * 0.016666668f, this.direction.y * 5.0f * 0.016666668f);
        this.sprite.setPosition(this.position.x, this.position.y);
        if (this.shark.getBody().getFixtureList().get(0).testPoint(this.position)) {
            this.shark.damage(0.025f);
            this.remove();
        }
        if (this.timer++ > 300) {
            this.remove();
        }
    }
}

