/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame.entities;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import walnoot.sharkgame.Util;
import walnoot.sharkgame.entities.Entity;
import walnoot.sharkgame.entities.SharkEntity;
import walnoot.sharkgame.screens.GameScreen;
import walnoot.sharkgame.stages.BoatStage;
import walnoot.sharkgame.stages.EpicEndingStage;
import walnoot.sharkgame.stages.ShootStage;
import walnoot.sharkgame.stages.WaitStage;

public class BoatEntity
extends Entity {
    private static final float SHARK_HIT_DAMAGE = 0.05f;
    private static final int IMMUNITY_TIME = 60;
    private float x = 20.0f;
    private float health = 1.0f;
    private Rectangle hitBox = new Rectangle();
    private int immunityTimer;
    private final Sprite sprite;
    private final GameScreen screen;
    private final SharkEntity shark;
    private BoatStage stage;

    public BoatEntity(SharkEntity shark, GameScreen screen) {
        this.shark = shark;
        this.screen = screen;
        this.sprite = new Sprite(Util.BOAT);
        this.sprite.setSize(2.0f, 1.0f);
        this.sprite.setOrigin(1.0f, 0.5f);
        this.stage = new WaitStage(this, shark, screen, new ShootStage(this, shark, screen));
    }

    @Override
    public void render(SpriteBatch batch) {
        this.sprite.setPosition(this.x - this.sprite.getOriginX(), 0.0f);
        this.sprite.draw(batch);
    }

    @Override
    public void update() {
        BoatStage newStage = this.stage.update();
        if (newStage != null) {
            this.stage = newStage;
        }
        this.x += this.stage.getSpeed() * 0.016666668f;
        this.hitBox.set(this.x - this.sprite.getOriginX(), 0.0f, this.sprite.getWidth(), this.sprite.getHeight());
        if (this.immunityTimer-- <= 0 && this.hitBox.contains(this.shark.getPosition())) {
            this.health -= 0.05f;
            this.screen.setBoathHealthSlider(this.health);
            this.immunityTimer = 60;
            if (this.health <= 0.0f) {
                this.setStage(new EpicEndingStage(this, this.shark, this.screen));
            }
        }
    }

    @Override
    public int getRenderLayer() {
        return 1;
    }

    public float getX() {
        return this.x;
    }

    public void setStage(BoatStage stage) {
        this.stage = stage;
    }
}

