/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Shape;

public class Util {
    public static final Vector2 TMP = new Vector2();
    private static final Color color = new Color(Color.WHITE);
    private static final Color targetColor = Util.getColor("051628ff");
    public static Texture BOAT;
    public static Texture BULLET;
    public static Texture FISH;
    public static Texture SHARK;
    public static Texture HEALTH_BACKGROUND;
    public static Texture LOGO;

    public static Color getColor(String hex) {
        return Color.valueOf(hex);
    }

    public static BodyDef getBodyDef() {
        BodyDef bodyDef = new BodyDef();
        bodyDef.linearDamping = 2.0f;
        bodyDef.angularDamping = 0.9f;
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.position.set(0.0f, 0.0f);
        return bodyDef;
    }

    public static FixtureDef getFixtureDef(Shape shape) {
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = shape;
        fixtureDef.density = 0.5f;
        fixtureDef.friction = 0.4f;
        fixtureDef.restitution = 1.0f;
        return fixtureDef;
    }

    public static int wrap(int x, int modulus) {
        return (x % modulus + modulus) % modulus;
    }

    public static void setDepthColor(Sprite sprite, float y) {
        color.set(Color.WHITE).lerp(targetColor, MathUtils.clamp(-y, 0.0f, 4.0f) / 4.0f);
        sprite.setColor(color);
    }
}

