/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import walnoot.sharkgame.InputHandler;
import walnoot.sharkgame.screens.LoadingScreen;
import walnoot.sharkgame.screens.UpdateScreen;

public class SharkGame
extends Game {
    public static final float UPDATES_PER_SECOND = 60.0f;
    public static final float SECONDS_PER_UPDATE = 0.016666668f;
    private UpdateScreen updateScreen;
    private float unprocessedSeconds;
    private InputMultiplexer inputs = new InputMultiplexer(InputHandler.instance);
    private Stage stage;

    @Override
    public void create() {
        Gdx.input.setInputProcessor(this.inputs);
        this.stage = new Stage();
        this.addInputProcessor(this.stage);
        this.setScreen(new LoadingScreen(this));
    }

    @Override
    public void render() {
        if (Gdx.input.isKeyPressed(131)) {
            Gdx.app.exit();
        }
        this.unprocessedSeconds += Gdx.graphics.getDeltaTime();
        while (this.unprocessedSeconds > 0.016666668f) {
            this.unprocessedSeconds -= 0.016666668f;
            this.updateScreen.update();
            InputHandler.instance.update();
        }
        super.render();
        this.stage.act(0.016666668f);
        this.stage.draw();
        Table.drawDebug(this.stage);
    }

    @Override
    public void setScreen(Screen screen) {
        this.inputs.removeProcessor(this.updateScreen);
        if (!(screen instanceof UpdateScreen)) {
            throw new IllegalArgumentException("Screen must be instace of UpdateScreen");
        }
        super.setScreen(screen);
        this.updateScreen = (UpdateScreen)screen;
        this.inputs.addProcessor((InputProcessor)((Object)screen));
    }

    public void addInputProcessor(InputProcessor processor) {
        this.inputs.addProcessor(processor);
    }

    public Stage getStage() {
        return this.stage;
    }
}

