/*
 * Decompiled with CFR 0.152.
 */
package walnoot.sharkgame;

import com.badlogic.gdx.InputProcessor;
import java.util.ArrayList;

public class InputHandler
implements InputProcessor {
    public static final InputHandler instance = new InputHandler();
    public Key moveLeft = new Key(21);
    public Key moveRight = new Key(22);
    public Key turnRight = new Key(45);
    public Key turnLeft = new Key(33);
    public Key start = new Key(62);
    private ArrayList<Key> keys;
    private boolean keyDown;
    private int scrollAmount;
    private boolean[] justTouched = new boolean[3];

    private InputHandler() {
    }

    public void update() {
        int i = 0;
        while (i < this.keys.size()) {
            this.keys.get(i).update();
            ++i;
        }
        this.keyDown = false;
        this.scrollAmount = 0;
        i = 0;
        while (i < this.justTouched.length) {
            this.justTouched[i] = false;
            ++i;
        }
    }

    public boolean isAnyKeyDown() {
        return this.keyDown;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public boolean isJustTouched() {
        return this.isJustTouched(0);
    }

    public boolean isJustTouched(int button) {
        return this.justTouched[button];
    }

    @Override
    public boolean keyDown(int keyCode) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i).has(keyCode)) {
                this.keys.get(i).press();
            }
            ++i;
        }
        this.keyDown = true;
        return false;
    }

    @Override
    public boolean keyUp(int keyCode) {
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.get(i).has(keyCode)) {
                this.keys.get(i).release();
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        this.justTouched[button] = true;
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        return false;
    }

    public boolean touchMoved(int x, int y) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        this.scrollAmount += amount;
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public class Key {
        private final int[] keyCodes;
        private boolean pressed;
        private boolean justPressed;

        public Key(int ... keyCodes) {
            this.keyCodes = keyCodes;
            if (InputHandler.this.keys == null) {
                InputHandler.this.keys = new ArrayList();
            }
            InputHandler.this.keys.add(this);
        }

        private void update() {
            this.justPressed = false;
        }

        public boolean has(int keyCode) {
            int i = 0;
            while (i < this.keyCodes.length) {
                if (this.keyCodes[i] == keyCode) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void press() {
            this.pressed = true;
            this.justPressed = true;
        }

        private void release() {
            this.pressed = false;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public boolean isJustPressed() {
            return this.justPressed;
        }
    }
}

