/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class SelectBox
extends Widget
implements Disableable {
    static final Vector2 tmpCoords = new Vector2();
    SelectBoxStyle style;
    String[] items;
    int selectedIndex = 0;
    private final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    SelectList list;
    private float prefWidth;
    private float prefHeight;
    private ClickListener clickListener;
    int maxListCount;
    boolean disabled;

    public SelectBox(Object[] items, Skin skin) {
        this(items, skin.get(SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, Skin skin, String styleName) {
        this(items, skin.get(styleName, SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, SelectBoxStyle style) {
        this.setStyle(style);
        this.setItems(items);
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (SelectBox.this.disabled) {
                    return false;
                }
                Stage stage = SelectBox.this.getStage();
                if (SelectBox.this.list == null) {
                    SelectBox.this.list = new SelectList();
                }
                SelectBox.this.list.show(stage);
                return true;
            }
        };
        this.addListener(this.clickListener);
    }

    public void setMaxListCount(int maxListCount) {
        this.maxListCount = maxListCount;
    }

    public int getMaxListCount() {
        return this.maxListCount;
    }

    public void setStyle(SelectBoxStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        } else {
            this.invalidateHierarchy();
        }
    }

    public SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            String[] strings = new String[objects.length];
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                strings[i] = String.valueOf(objects[i]);
            }
            objects = strings;
        }
        this.items = (String[])objects;
        this.selectedIndex = 0;
        Drawable bg = this.style.background;
        BitmapFont font = this.style.font;
        this.prefHeight = Math.max(bg.getTopHeight() + bg.getBottomHeight() + font.getCapHeight() - font.getDescent() * 2.0f, bg.getMinHeight());
        float maxItemWidth = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            maxItemWidth = Math.max(font.getBounds((CharSequence)this.items[i]).width, maxItemWidth);
        }
        this.prefWidth = bg.getLeftWidth() + bg.getRightWidth() + maxItemWidth;
        List.ListStyle listStyle = this.style.listStyle;
        ScrollPane.ScrollPaneStyle scrollStyle = this.style.scrollStyle;
        this.prefWidth = Math.max(this.prefWidth, maxItemWidth + scrollStyle.background.getLeftWidth() + scrollStyle.background.getRightWidth() + listStyle.selection.getLeftWidth() + listStyle.selection.getRightWidth() + Math.max(this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.getMinWidth() : 0.0f, this.style.scrollStyle.vScrollKnob != null ? this.style.scrollStyle.vScrollKnob.getMinWidth() : 0.0f));
        if (this.items.length > 0) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            this.fire(changeEvent);
            Pools.free(changeEvent);
        }
        this.invalidateHierarchy();
    }

    public String[] getItems() {
        return this.items;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Drawable background = this.disabled ? this.style.backgroundDisabled : (this.list != null && this.list.getParent() != null && this.style.backgroundOpen != null ? this.style.backgroundOpen : (this.clickListener.isOver() && this.style.backgroundOver != null ? this.style.backgroundOver : this.style.background));
        BitmapFont font = this.style.font;
        Color fontColor = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : this.style.fontColor;
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        background.draw(batch, x, y, width, height);
        if (this.items.length > 0) {
            float availableWidth = width - background.getLeftWidth() - background.getRightWidth();
            int numGlyphs = font.computeVisibleGlyphs(this.items[this.selectedIndex], 0, this.items[this.selectedIndex].length(), availableWidth);
            this.bounds.set(font.getBounds(this.items[this.selectedIndex]));
            float textY = (int)((height -= background.getBottomHeight() + background.getTopHeight()) / 2.0f + background.getBottomHeight() + this.bounds.height / 2.0f);
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, this.items[this.selectedIndex], x + background.getLeftWidth(), y + textY, 0, numGlyphs);
        }
    }

    public void setSelection(int selection) {
        this.selectedIndex = selection;
    }

    public void setSelection(String item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(item)) continue;
            this.selectedIndex = i;
        }
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public String getSelection() {
        return this.items[this.selectedIndex];
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled && !this.disabled) {
            this.hideList();
        }
        this.disabled = disabled;
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    public void hideList() {
        if (this.list == null || this.list.getParent() == null) {
            return;
        }
        this.list.addAction(Actions.sequence((Action)Actions.fadeOut(0.15f, Interpolation.fade), (Action)Actions.removeActor()));
    }

    public static class SelectBoxStyle {
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color disabledFontColor;
        public Drawable background;
        public ScrollPane.ScrollPaneStyle scrollStyle;
        public List.ListStyle listStyle;
        public Drawable backgroundOver;
        public Drawable backgroundOpen;
        public Drawable backgroundDisabled;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont font, Color fontColor, Drawable background, ScrollPane.ScrollPaneStyle scrollStyle, List.ListStyle listStyle) {
            this.font = font;
            this.fontColor.set(fontColor);
            this.background = background;
            this.scrollStyle = scrollStyle;
            this.listStyle = listStyle;
        }

        public SelectBoxStyle(SelectBoxStyle style) {
            this.font = style.font;
            this.fontColor.set(style.fontColor);
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.backgroundOver = style.backgroundOver;
            this.backgroundOpen = style.backgroundOpen;
            this.backgroundDisabled = style.backgroundDisabled;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(style.scrollStyle);
            this.listStyle = new List.ListStyle(style.listStyle);
        }
    }

    class SelectList
    extends ScrollPane {
        final List list;
        final Vector2 screenCoords;

        public SelectList() {
            super(null, SelectBox.this.style.scrollStyle);
            this.screenCoords = new Vector2();
            this.setOverscroll(false, false);
            this.setFadeScrollBars(false);
            this.list = new List(new Object[0], SelectBox.this.style.listStyle);
            this.setWidget(this.list);
            this.list.addListener(new InputListener(){

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    SelectList.this.list.setSelectedIndex(Math.min(SelectBox.this.items.length - 1, (int)((SelectList.this.list.getHeight() - y) / SelectList.this.list.getItemHeight())));
                    return true;
                }
            });
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getTarget() == SelectList.this.list) {
                        return true;
                    }
                    SelectBox.this.hideList();
                    return false;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (SelectList.this.hit(x, y, true) == SelectList.this.list) {
                        SelectBox.this.setSelection(SelectList.this.list.getSelectedIndex());
                        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                        SelectBox.this.fire(changeEvent);
                        Pools.free(changeEvent);
                        SelectBox.this.hideList();
                    }
                }
            });
        }

        public void show(Stage stage) {
            stage.addActor(this);
            SelectBox.this.localToStageCoordinates(tmpCoords.set(0.0f, 0.0f));
            this.screenCoords.set(tmpCoords);
            this.list.setItems(SelectBox.this.items);
            this.list.setSelectedIndex(SelectBox.this.selectedIndex);
            float itemHeight = this.list.getItemHeight();
            float height = itemHeight * (float)(SelectBox.this.maxListCount <= 0 ? SelectBox.this.items.length : Math.min(SelectBox.this.maxListCount, SelectBox.this.items.length));
            Drawable background = this.getStyle().background;
            if (background != null) {
                height += background.getTopHeight() + background.getBottomHeight();
            }
            float heightBelow = SelectBox.tmpCoords.y;
            float heightAbove = stage.getCamera().viewportHeight - SelectBox.tmpCoords.y - SelectBox.this.getHeight();
            boolean below = true;
            if (height > heightBelow) {
                if (heightAbove > heightBelow) {
                    below = false;
                    height = Math.min(height, heightAbove);
                } else {
                    height = heightBelow;
                }
            }
            if (below) {
                this.setY(SelectBox.tmpCoords.y - height);
            } else {
                this.setY(SelectBox.tmpCoords.y + SelectBox.this.getHeight());
            }
            this.setX(SelectBox.tmpCoords.x);
            this.setWidth(SelectBox.this.getWidth());
            this.setHeight(height);
            this.scrollToCenter(0.0f, this.list.getHeight() - (float)SelectBox.this.selectedIndex * itemHeight - itemHeight / 2.0f, 0.0f, 0.0f);
            this.updateVisualScroll();
            this.clearActions();
            this.getColor().a = 0.0f;
            this.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
            stage.setScrollFocus(this);
        }

        @Override
        public Actor hit(float x, float y, boolean touchable) {
            Actor actor = super.hit(x, y, touchable);
            return actor != null ? actor : this;
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            SelectBox.this.localToStageCoordinates(tmpCoords.set(0.0f, 0.0f));
            if (SelectBox.tmpCoords.x != this.screenCoords.x || SelectBox.tmpCoords.y != this.screenCoords.y) {
                SelectBox.this.hideList();
            }
        }
    }
}

