/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class HorizontalGroup
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid = true;
    private int alignment;
    private boolean reverse;
    private float spacing;

    public HorizontalGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        SnapshotArray<Actor> children = this.getChildren();
        int n = children.size;
        this.prefWidth = this.spacing * (float)(n - 1);
        this.prefHeight = 0.0f;
        for (int i = 0; i < n; ++i) {
            Actor child = (Actor)children.get(i);
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                this.prefWidth += layout.getPrefWidth();
                this.prefHeight = Math.max(this.prefHeight, layout.getPrefHeight());
                continue;
            }
            this.prefWidth += child.getWidth();
            this.prefHeight = Math.max(this.prefHeight, child.getHeight());
        }
    }

    @Override
    public void layout() {
        float spacing = this.spacing;
        float groupHeight = this.getHeight();
        float x = this.reverse ? this.getWidth() : 0.0f;
        float dir = this.reverse ? -1.0f : 1.0f;
        SnapshotArray<Actor> children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            float height;
            float width;
            Actor child = (Actor)children.get(i);
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            } else {
                width = child.getWidth();
                height = child.getHeight();
            }
            float y = (this.alignment & 4) != 0 ? 0.0f : ((this.alignment & 2) != 0 ? groupHeight - height : (groupHeight - height) / 2.0f);
            if (this.reverse) {
                x += (width + spacing) * dir;
            }
            child.setBounds(x, y, width, height);
            if (this.reverse) continue;
            x += (width + spacing) * dir;
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
    }
}

