/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

public class Button
extends Table
implements Disableable {
    private ButtonStyle style;
    boolean isChecked;
    boolean isDisabled;
    ButtonGroup buttonGroup;
    private ClickListener clickListener;

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(ButtonStyle.class));
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
    }

    public Button(Skin skin, String styleName) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(styleName, ButtonStyle.class));
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
    }

    public Button(Actor child, Skin skin, String styleName) {
        this(child, skin.get(styleName, ButtonStyle.class));
    }

    public Button(Actor child, ButtonStyle style) {
        this.initialize();
        this.add(child);
        this.setStyle(style);
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
    }

    public Button(ButtonStyle style) {
        this.initialize();
        this.setStyle(style);
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
    }

    public Button() {
        this.initialize();
    }

    private void initialize() {
        this.setTouchable(Touchable.enabled);
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Button.this.isDisabled) {
                    return;
                }
                Button.this.setChecked(!Button.this.isChecked);
            }
        };
        this.addListener(this.clickListener);
    }

    public Button(Drawable up) {
        this(new ButtonStyle(up, null, null));
    }

    public Button(Drawable up, Drawable down) {
        this(new ButtonStyle(up, down, null));
    }

    public Button(Drawable up, Drawable down, Drawable checked) {
        this(new ButtonStyle(up, down, checked));
    }

    public Button(Actor child, Skin skin) {
        this(child, skin.get(ButtonStyle.class));
    }

    public void setChecked(boolean isChecked) {
        if (this.isChecked == isChecked) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
        if (!this.isDisabled) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.isChecked = !isChecked;
            }
            Pools.free(changeEvent);
        }
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isPressed() {
        return this.clickListener.isPressed();
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public void setStyle(ButtonStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        Drawable background = style.up;
        if (background == null && (background = style.down) == null) {
            background = style.checked;
        }
        if (background != null) {
            this.padBottom(background.getBottomHeight());
            this.padTop(background.getTopHeight());
            this.padLeft(background.getLeftWidth());
            this.padRight(background.getRightWidth());
        }
        this.invalidateHierarchy();
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        int i;
        this.validate();
        Drawable background = null;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.isPressed() && !this.isDisabled) {
            background = this.style.down == null ? this.style.up : this.style.down;
            offsetX = this.style.pressedOffsetX;
            offsetY = this.style.pressedOffsetY;
        } else {
            background = this.isDisabled && this.style.disabled != null ? this.style.disabled : (this.isChecked && this.style.checked != null ? (this.isOver() && this.style.checkedOver != null ? this.style.checkedOver : this.style.checked) : (this.isOver() && this.style.over != null ? this.style.over : this.style.up));
            offsetX = this.style.unpressedOffsetX;
            offsetY = this.style.unpressedOffsetY;
        }
        if (background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        SnapshotArray<Actor> children = this.getChildren();
        for (i = 0; i < children.size; ++i) {
            ((Actor)children.get(i)).translate(offsetX, offsetY);
        }
        super.draw(batch, parentAlpha);
        for (i = 0; i < children.size; ++i) {
            ((Actor)children.get(i)).translate(-offsetX, -offsetY);
        }
    }

    @Override
    protected void drawBackground(SpriteBatch batch, float parentAlpha) {
    }

    @Override
    public float getPrefWidth() {
        float width = super.getPrefWidth();
        if (this.style.up != null) {
            width = Math.max(width, this.style.up.getMinWidth());
        }
        if (this.style.down != null) {
            width = Math.max(width, this.style.down.getMinWidth());
        }
        if (this.style.checked != null) {
            width = Math.max(width, this.style.checked.getMinWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = super.getPrefHeight();
        if (this.style.up != null) {
            height = Math.max(height, this.style.up.getMinHeight());
        }
        if (this.style.down != null) {
            height = Math.max(height, this.style.down.getMinHeight());
        }
        if (this.style.checked != null) {
            height = Math.max(height, this.style.checked.getMinHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    public static class ButtonStyle {
        public Drawable up;
        public Drawable down;
        public Drawable over;
        public Drawable checked;
        public Drawable checkedOver;
        public Drawable disabled;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(Drawable up, Drawable down, Drawable checked) {
            this.up = up;
            this.down = down;
            this.checked = checked;
        }

        public ButtonStyle(ButtonStyle style) {
            this.up = style.up;
            this.down = style.down;
            this.over = style.over;
            this.checked = style.checked;
            this.checkedOver = style.checkedOver;
            this.disabled = style.disabled;
            this.pressedOffsetX = style.pressedOffsetX;
            this.pressedOffsetY = style.pressedOffsetY;
            this.unpressedOffsetX = style.unpressedOffsetX;
            this.unpressedOffsetY = style.unpressedOffsetY;
        }
    }
}

