/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    private static final float NORMALIZATION_TOLERANCE = 1.0E-5f;
    private static Quaternion tmp1 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    private static Quaternion tmp2 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Quaternion() {
        this.idt();
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Vector3 axis, float angle) {
        this.set(axis, angle);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(Vector3 axis, float angle) {
        return this.setFromAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion cpy() {
        return new Quaternion(this);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public String toString() {
        return "[" + this.x + "|" + this.y + "|" + this.z + "|" + this.w + "]";
    }

    public Quaternion setEulerAngles(float yaw, float pitch, float roll) {
        yaw = (float)Math.toRadians(yaw);
        pitch = (float)Math.toRadians(pitch);
        roll = (float)Math.toRadians(roll);
        float num9 = roll * 0.5f;
        float num6 = (float)Math.sin(num9);
        float num5 = (float)Math.cos(num9);
        float num8 = pitch * 0.5f;
        float num4 = (float)Math.sin(num8);
        float num3 = (float)Math.cos(num8);
        float num7 = yaw * 0.5f;
        float num2 = (float)Math.sin(num7);
        float num = (float)Math.cos(num7);
        float f1 = num * num4;
        float f2 = num2 * num3;
        float f3 = num * num3;
        float f4 = num2 * num4;
        this.x = f1 * num5 + f2 * num6;
        this.y = f2 * num5 - f1 * num6;
        this.z = f3 * num6 - f4 * num5;
        this.w = f3 * num5 + f4 * num6;
        return this;
    }

    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaternion nor() {
        float len = this.len2();
        if (len != 0.0f && Math.abs(len - 1.0f) > 1.0E-5f) {
            len = (float)Math.sqrt(len);
            this.w /= len;
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 transform(Vector3 v) {
        tmp2.set(this);
        tmp2.conjugate();
        tmp2.mulLeft(tmp1.set(v.x, v.y, v.z, 0.0f)).mulLeft(this);
        v.x = Quaternion.tmp2.x;
        v.y = Quaternion.tmp2.y;
        v.z = Quaternion.tmp2.z;
        return v;
    }

    public Quaternion mul(Quaternion q) {
        float newX = this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y;
        float newY = this.w * q.y + this.y * q.w + this.z * q.x - this.x * q.z;
        float newZ = this.w * q.z + this.z * q.w + this.x * q.y - this.y * q.x;
        float newW = this.w * q.w - this.x * q.x - this.y * q.y - this.z * q.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public Quaternion mulLeft(Quaternion q) {
        float newX = q.w * this.x + q.x * this.w + q.y * this.z - q.z * this.y;
        float newY = q.w * this.y + q.y * this.w + q.z * this.x - q.x * this.z;
        float newZ = q.w * this.z + q.z * this.w + q.x * this.y - q.y * this.x;
        float newW = q.w * this.w - q.x * this.x - q.y * this.y - q.z * this.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public void toMatrix(float[] matrix) {
        float xx = this.x * this.x;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yy = this.y * this.y;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zz = this.z * this.z;
        float zw = this.z * this.w;
        matrix[0] = 1.0f - 2.0f * (yy + zz);
        matrix[4] = 2.0f * (xy - zw);
        matrix[8] = 2.0f * (xz + yw);
        matrix[12] = 0.0f;
        matrix[1] = 2.0f * (xy + zw);
        matrix[5] = 1.0f - 2.0f * (xx + zz);
        matrix[9] = 2.0f * (yz - xw);
        matrix[13] = 0.0f;
        matrix[2] = 2.0f * (xz - yw);
        matrix[6] = 2.0f * (yz + xw);
        matrix[10] = 1.0f - 2.0f * (xx + yy);
        matrix[14] = 0.0f;
        matrix[3] = 0.0f;
        matrix[7] = 0.0f;
        matrix[11] = 0.0f;
        matrix[15] = 1.0f;
    }

    public Quaternion idt() {
        return this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion setFromAxis(Vector3 axis, float angle) {
        return this.setFromAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion setFromAxis(float x, float y, float z, float angle) {
        float d = Vector3.len(x, y, z);
        if (d == 0.0f) {
            return this.idt();
        }
        d = 1.0f / d;
        float l_ang = angle * ((float)Math.PI / 180);
        float l_sin = (float)Math.sin(l_ang / 2.0f);
        float l_cos = (float)Math.cos(l_ang / 2.0f);
        return this.set(d * x * l_sin, d * y * l_sin, d * z * l_sin, l_cos).nor();
    }

    public Quaternion setFromMatrix(Matrix4 matrix) {
        return this.setFromAxes(matrix.val[0], matrix.val[4], matrix.val[8], matrix.val[1], matrix.val[5], matrix.val[9], matrix.val[2], matrix.val[6], matrix.val[10]);
    }

    public Quaternion setFromAxes(float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        double z;
        double y;
        double x;
        double w;
        float m00 = xx;
        float m01 = xy;
        float m02 = xz;
        float m10 = yx;
        float m11 = yy;
        float m12 = yz;
        float m20 = zx;
        float m21 = zy;
        float m22 = zz;
        float t = m00 + m11 + m22;
        if (t >= 0.0f) {
            double s = Math.sqrt(t + 1.0f);
            w = 0.5 * s;
            s = 0.5 / s;
            x = (double)(m21 - m12) * s;
            y = (double)(m02 - m20) * s;
            z = (double)(m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            double s = Math.sqrt(1.0 + (double)m00 - (double)m11 - (double)m22);
            x = s * 0.5;
            s = 0.5 / s;
            y = (double)(m10 + m01) * s;
            z = (double)(m02 + m20) * s;
            w = (double)(m21 - m12) * s;
        } else if (m11 > m22) {
            double s = Math.sqrt(1.0 + (double)m11 - (double)m00 - (double)m22);
            y = s * 0.5;
            s = 0.5 / s;
            x = (double)(m10 + m01) * s;
            z = (double)(m21 + m12) * s;
            w = (double)(m02 - m20) * s;
        } else {
            double s = Math.sqrt(1.0 + (double)m22 - (double)m00 - (double)m11);
            z = s * 0.5;
            s = 0.5 / s;
            x = (double)(m02 + m20) * s;
            y = (double)(m21 + m12) * s;
            w = (double)(m10 - m01) * s;
        }
        return this.set((float)x, (float)y, (float)z, (float)w);
    }

    public Quaternion setFromCross(Vector3 v1, Vector3 v2) {
        float dot = MathUtils.clamp(v1.dot(v2), -1.0f, 1.0f);
        float angle = (float)Math.acos(dot) * 57.295776f;
        return this.setFromAxis(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x, angle);
    }

    public Quaternion setFromCross(float x1, float y1, float z1, float x2, float y2, float z2) {
        float dot = MathUtils.clamp(Vector3.dot(x1, y1, z1, x2, y2, z2), -1.0f, 1.0f);
        float angle = (float)Math.acos(dot) * 57.295776f;
        return this.setFromAxis(y1 * z2 - z1 * y2, z1 * x2 - x1 * z2, x1 * y2 - y1 * x2, angle);
    }

    public Quaternion slerp(Quaternion end, float alpha) {
        float dot = this.dot(end);
        float absDot = dot < 0.0f ? -dot : dot;
        float scale0 = 1.0f - alpha;
        float scale1 = alpha;
        if ((double)(1.0f - absDot) > 0.1) {
            double angle = Math.acos(absDot);
            double invSinTheta = 1.0 / Math.sin(angle);
            scale0 = (float)(Math.sin((double)(1.0f - alpha) * angle) * invSinTheta);
            scale1 = (float)(Math.sin((double)alpha * angle) * invSinTheta);
        }
        if (dot < 0.0f) {
            scale1 = -scale1;
        }
        this.x = scale0 * this.x + scale1 * end.x;
        this.y = scale0 * this.y + scale1 * end.y;
        this.z = scale0 * this.z + scale1 * end.z;
        this.w = scale0 * this.w + scale1 * end.w;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaternion)) {
            return false;
        }
        Quaternion comp = (Quaternion)o;
        return this.x == comp.x && this.y == comp.y && this.z == comp.z && this.w == comp.w;
    }

    public float dot(Quaternion other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Quaternion mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public float getAxisAngle(Vector3 axis) {
        if (this.w > 1.0f) {
            this.nor();
        }
        float angle = (float)(2.0 * Math.acos(this.w));
        double s = Math.sqrt(1.0f - this.w * this.w);
        if (s < (double)1.0E-5f) {
            axis.x = this.x;
            axis.y = this.y;
            axis.z = this.z;
        } else {
            axis.x = (float)((double)this.x / s);
            axis.y = (float)((double)this.y / s);
            axis.z = (float)((double)this.z / s);
        }
        return 57.295776f * angle;
    }
}

