/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ShapeRenderer {
    ImmediateModeRenderer renderer;
    boolean matrixDirty = false;
    Matrix4 projView = new Matrix4();
    Matrix4 transform = new Matrix4();
    Matrix4 combined = new Matrix4();
    Matrix4 tmp = new Matrix4();
    Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    ShapeType currType = null;

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int maxVertices) {
        this.renderer = Gdx.graphics.isGL20Available() ? new ImmediateModeRenderer20(maxVertices, false, true, 0) : new ImmediateModeRenderer10(maxVertices);
        this.projView.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.matrixDirty = true;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public Color getColor() {
        return this.color;
    }

    public void setProjectionMatrix(Matrix4 matrix) {
        this.projView.set(matrix);
        this.matrixDirty = true;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projView;
    }

    public void setTransformMatrix(Matrix4 matrix) {
        this.transform.set(matrix);
        this.matrixDirty = true;
    }

    public Matrix4 getTransformMatrix() {
        return this.transform;
    }

    public void identity() {
        this.transform.idt();
        this.matrixDirty = true;
    }

    public void translate(float x, float y, float z) {
        this.transform.translate(x, y, z);
        this.matrixDirty = true;
    }

    public void rotate(float axisX, float axisY, float axisZ, float angle) {
        this.transform.rotate(axisX, axisY, axisZ, angle);
        this.matrixDirty = true;
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.transform.scale(scaleX, scaleY, scaleZ);
        this.matrixDirty = true;
    }

    public void begin(ShapeType type) {
        if (this.currType != null) {
            throw new GdxRuntimeException("Call end() before beginning a new shape batch");
        }
        this.currType = type;
        if (this.matrixDirty) {
            this.combined.set(this.projView);
            Matrix4.mul(this.combined.val, this.transform.val);
            this.matrixDirty = false;
        }
        this.renderer.begin(this.combined, this.currType.getGlType());
    }

    public void point(float x, float y, float z) {
        if (this.currType != ShapeType.Point) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Point)");
        }
        this.checkDirty();
        this.checkFlush(1);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
    }

    public final void line(float x, float y, float z, float x2, float y2, float z2) {
        this.line(x, y, z, x2, y2, z2, this.color, this.color);
    }

    public final void line(Vector3 v0, Vector3 v1) {
        this.line(v0.x, v0.y, v0.z, v1.x, v1.y, v1.z, this.color, this.color);
    }

    public final void line(float x, float y, float x2, float y2) {
        this.line(x, y, 0.0f, x2, y2, 0.0f, this.color, this.color);
    }

    public final void line(Vector2 v0, Vector2 v1) {
        this.line(v0.x, v0.y, 0.0f, v1.x, v1.y, 0.0f, this.color, this.color);
    }

    public final void line(float x, float y, float x2, float y2, Color c1, Color c2) {
        this.line(x, y, 0.0f, x2, y2, 0.0f, c1, c2);
    }

    public void line(float x, float y, float z, float x2, float y2, float z2, Color c1, Color c2) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(2);
        this.renderer.color(c1.r, c1.g, c1.b, c1.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(c2.r, c2.g, c2.b, c2.a);
        this.renderer.vertex(x2, y2, z2);
    }

    public void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(segments * 2 + 2);
        float subdiv_step = 1.0f / (float)segments;
        float subdiv_step2 = subdiv_step * subdiv_step;
        float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        float pre1 = 3.0f * subdiv_step;
        float pre2 = 3.0f * subdiv_step2;
        float pre4 = 6.0f * subdiv_step2;
        float pre5 = 6.0f * subdiv_step3;
        float tmp1x = x1 - cx1 * 2.0f + cx2;
        float tmp1y = y1 - cy1 * 2.0f + cy2;
        float tmp2x = (cx1 - cx2) * 3.0f - x1 + x2;
        float tmp2y = (cy1 - cy2) * 3.0f - y1 + y2;
        float fx = x1;
        float fy = y1;
        float dfx = (cx1 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        float dfy = (cy1 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        float ddfx = tmp1x * pre4 + tmp2x * pre5;
        float ddfy = tmp1y * pre4 + tmp2y * pre5;
        float dddfx = tmp2x * pre5;
        float dddfy = tmp2y * pre5;
        while (segments-- > 0) {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(fx, fy, 0.0f);
            fx += dfx;
            fy += dfy;
            dfx += ddfx;
            dfy += ddfy;
            ddfx += dddfx;
            ddfy += dddfy;
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(fx, fy, 0.0f);
        }
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(fx, fy, 0.0f);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x2, y2, 0.0f);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(6);
        if (this.currType == ShapeType.Line) {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
        } else {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x3, y3, 0.0f);
        }
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3, Color col1, Color col2, Color col3) {
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(6);
        if (this.currType == ShapeType.Line) {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
        } else {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
        }
    }

    public void rect(float x, float y, float width, float height) {
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(8);
        if (this.currType == ShapeType.Line) {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
        } else {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
        }
    }

    public void rect(float x, float y, float width, float height, Color col1, Color col2, Color col3, Color col4) {
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(8);
        if (this.currType == ShapeType.Line) {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x, y, 0.0f);
        } else {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x, y, 0.0f);
        }
    }

    public void rect(float x, float y, float width, float height, float originX, float originY, float rotation) {
        this.rect(x, y, width, height, originX, originY, rotation, this.color, this.color, this.color, this.color);
    }

    public void rect(float x, float y, float width, float height, float originX, float originY, float rotation, Color col1, Color col2, Color col3, Color col4) {
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(8);
        float r = (float)Math.toRadians(rotation);
        float c = (float)Math.cos(r);
        float s = (float)Math.sin(r);
        float x1 = x + c * (0.0f - originX) + -s * (0.0f - originY) + originX;
        float y1 = y + s * (0.0f - originX) + c * (0.0f - originY) + originY;
        float x2 = x + c * (width - originX) + -s * (0.0f - originY) + originX;
        float y2 = y + s * (width - originX) + c * (0.0f - originY) + originY;
        float x3 = x + c * (width - originX) + -s * (height - originY) + originX;
        float y3 = y + s * (width - originX) + c * (height - originY) + originY;
        float x4 = x + c * (0.0f - originX) + -s * (height - originY) + originX;
        float y4 = y + s * (0.0f - originX) + c * (height - originY) + originY;
        if (this.currType == ShapeType.Line) {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
        } else {
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
        }
    }

    public void box(float x, float y, float z, float width, float height, float depth) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(16);
        depth = -depth;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + width, y + height, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y, z + depth);
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x, y + height, z + depth);
    }

    public void x(float x, float y, float radius) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.line(x - radius, y - radius, x + radius, y + radius);
        this.line(x - radius, y + radius, x + radius, y - radius);
    }

    public void arc(float x, float y, float radius, float start, float angle) {
        this.arc(x, y, radius, start, angle, Math.max(1, (int)(6.0f * (float)Math.cbrt(radius) * (angle / 360.0f))));
    }

    public void arc(float x, float y, float radius, float start, float angle, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        float theta = 6.283185f * (angle / 360.0f) / (float)segments;
        float cos = MathUtils.cos(theta);
        float sin = MathUtils.sin(theta);
        float cx = radius * MathUtils.cos(start * ((float)Math.PI / 180));
        float cy = radius * MathUtils.sin(start * ((float)Math.PI / 180));
        if (this.currType == ShapeType.Line) {
            this.checkFlush(segments * 2 + 2);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        } else {
            this.checkFlush(segments * 3 + 3);
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x, y, 0.0f);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        }
        float temp = cx;
        cx = 0.0f;
        cy = 0.0f;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
    }

    public void circle(float x, float y, float radius) {
        this.circle(x, y, radius, Math.max(1, (int)(6.0f * (float)Math.cbrt(radius))));
    }

    public void circle(float x, float y, float radius, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        float angle = 6.283185f / (float)segments;
        float cos = MathUtils.cos(angle);
        float sin = MathUtils.sin(angle);
        float cx = radius;
        float cy = 0.0f;
        if (this.currType == ShapeType.Line) {
            this.checkFlush(segments * 2 + 2);
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        } else {
            this.checkFlush(segments * 3 + 3);
            --segments;
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x, y, 0.0f);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        }
        float temp = cx;
        cx = radius;
        cy = 0.0f;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
    }

    public void ellipse(float x, float y, float width, float height) {
        this.ellipse(x, y, width, height, Math.max(1, (int)(12.0f * (float)Math.cbrt(Math.max(width * 0.5f, height * 0.5f)))));
    }

    public void ellipse(float x, float y, float width, float height, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(segments * 3);
        float angle = 6.283185f / (float)segments;
        float cx = x + width / 2.0f;
        float cy = y + height / 2.0f;
        if (this.currType == ShapeType.Line) {
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(cx + width * 0.5f * MathUtils.cos((float)i * angle), cy + height * 0.5f * MathUtils.sin((float)i * angle), 0.0f);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(cx + width * 0.5f * MathUtils.cos((float)(i + 1) * angle), cy + height * 0.5f * MathUtils.sin((float)(i + 1) * angle), 0.0f);
            }
        } else {
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(cx + width * 0.5f * MathUtils.cos((float)i * angle), cy + height * 0.5f * MathUtils.sin((float)i * angle), 0.0f);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(cx, cy, 0.0f);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(cx + width * 0.5f * MathUtils.cos((float)(i + 1) * angle), cy + height * 0.5f * MathUtils.sin((float)(i + 1) * angle), 0.0f);
            }
        }
    }

    public void cone(float x, float y, float z, float radius, float height) {
        this.cone(x, y, z, radius, height, Math.max(1, (int)(4.0f * (float)Math.sqrt(radius))));
    }

    public void cone(float x, float y, float z, float radius, float height, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.currType != ShapeType.Filled && this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.checkDirty();
        this.checkFlush(segments * 4 + 2);
        float angle = 6.283185f / (float)segments;
        float cos = MathUtils.cos(angle);
        float sin = MathUtils.sin(angle);
        float cx = radius;
        float cy = 0.0f;
        if (this.currType == ShapeType.Line) {
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x, y, z + height);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, z);
        } else {
            --segments;
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x, y, z);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
                float temp = cx;
                float temp2 = cy;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + temp, y + temp2, z);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x + cx, y + cy, z);
                this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
                this.renderer.vertex(x, y, z + height);
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x, y, z);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x + cx, y + cy, z);
        }
        cx = radius;
        cy = 0.0f;
        this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
        this.renderer.vertex(x + cx, y + cy, z);
    }

    public void polygon(float[] vertices) {
        this.polygon(vertices, 0, vertices.length);
    }

    public void polygon(float[] vertices, int offset, int count) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        if (count < 6) {
            throw new IllegalArgumentException("Polygons must contain at least 3 points.");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Polygons must have an even number of vertices.");
        }
        this.checkDirty();
        this.checkFlush(count);
        float firstX = vertices[0];
        float firstY = vertices[1];
        int n = offset + count;
        for (int i = offset; i < n; i += 2) {
            float y2;
            float x2;
            float x1 = vertices[i];
            float y1 = vertices[i + 1];
            if (i + 2 >= count) {
                x2 = firstX;
                y2 = firstY;
            } else {
                x2 = vertices[i + 2];
                y2 = vertices[i + 3];
            }
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
        }
    }

    public void polyline(float[] vertices) {
        this.polyline(vertices, 0, vertices.length);
    }

    public void polyline(float[] vertices, int offset, int count) {
        if (this.currType != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        if (count < 4) {
            throw new IllegalArgumentException("Polylines must contain at least 2 points.");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Polylines must have an even number of vertices.");
        }
        this.checkDirty();
        this.checkFlush(count);
        int n = offset + count - 2;
        for (int i = offset; i < n; i += 2) {
            float x1 = vertices[i];
            float y1 = vertices[i + 1];
            float x2 = vertices[i + 2];
            float y2 = vertices[i + 3];
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(this.color.r, this.color.g, this.color.b, this.color.a);
            this.renderer.vertex(x2, y2, 0.0f);
        }
    }

    private void checkDirty() {
        if (!this.matrixDirty) {
            return;
        }
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    private void checkFlush(int newVertices) {
        if (this.renderer.getMaxVertices() - this.renderer.getNumVertices() >= newVertices) {
            return;
        }
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    public void end() {
        this.renderer.end();
        this.currType = null;
    }

    public void flush() {
        ShapeType type = this.currType;
        this.end();
        this.begin(type);
    }

    public ShapeType getCurrentType() {
        return this.currType;
    }

    public ImmediateModeRenderer getRenderer() {
        return this.renderer;
    }

    public void dispose() {
        this.renderer.dispose();
    }

    public static enum ShapeType {
        Point(0),
        Line(1),
        Filled(4);

        private final int glType;

        private ShapeType(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }
    }
}

