/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class DepthShader
extends DefaultShader {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int numBones;
    public final int weights;
    private int originalCullFace;

    public static final String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static final String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(Renderable renderable, Config config) {
        String prefix = "";
        long mask = renderable.material.getMask();
        long attributes = renderable.mesh.getVertexAttributes().getMask();
        if ((attributes & 0x40L) == 64L) {
            int n = renderable.mesh.getVertexAttributes().size();
            for (int i = 0; i < n; ++i) {
                VertexAttribute attr = renderable.mesh.getVertexAttributes().get(i);
                if (attr.usage != 64) continue;
                prefix = prefix + "#define boneWeight" + attr.unit + "Flag\n";
            }
        }
        if (renderable.bones != null && config.numBones > 0) {
            prefix = prefix + "#define numBones " + config.numBones + "\n";
        }
        if (!config.depthBufferOnly) {
            prefix = prefix + "#define PackedDepthFlag\n";
        }
        return prefix;
    }

    public DepthShader(Renderable renderable) {
        this(renderable, new Config());
    }

    public DepthShader(Renderable renderable, Config config) {
        this(renderable, config, DepthShader.createPrefix(renderable, config));
    }

    public DepthShader(Renderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShader != null ? config.vertexShader : DepthShader.getDefaultVertexShader(), config.fragmentShader != null ? config.fragmentShader : DepthShader.getDefaultFragmentShader());
    }

    public DepthShader(Renderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public DepthShader(Renderable renderable, Config config, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader.Config)config, shaderProgram);
        this.numBones = renderable.bones == null ? 0 : config.numBones;
        int w = 0;
        int n = renderable.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = renderable.mesh.getVertexAttributes().get(i);
            if (attr.usage != 64) continue;
            w |= 1 << attr.unit;
        }
        this.weights = w;
    }

    @Override
    public void begin(Camera camera, RenderContext context) {
        this.originalCullFace = DefaultShader.defaultCullFace;
        DefaultShader.defaultCullFace = 1028;
        super.begin(camera, context);
    }

    @Override
    public void end() {
        super.end();
        DefaultShader.defaultCullFace = this.originalCullFace;
        Gdx.gl20.glDisable(32823);
    }

    @Override
    public boolean canRender(Renderable renderable) {
        boolean skinned = (renderable.mesh.getVertexAttributes().getMask() & 0x40L) == 64L;
        if (skinned != this.numBones > 0) {
            return false;
        }
        if (!skinned) {
            return true;
        }
        int w = 0;
        int n = renderable.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = renderable.mesh.getVertexAttributes().get(i);
            if (attr.usage != 64) continue;
            w |= 1 << attr.unit;
        }
        return w == this.weights;
    }

    public static class Config
    extends DefaultShader.Config {
        public boolean depthBufferOnly = false;

        public Config() {
        }

        public Config(String vertexShader, String fragmentShader) {
            super(vertexShader, fragmentShader);
        }
    }
}

