/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class FreeTypeFontGenerator
implements Disposable {
    public static final String DEFAULT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    final FreeType.Library library;
    final FreeType.Face face;
    final String filePath;
    boolean bitmapped = false;
    private static int maxTextureSize = 1024;
    public static final int NO_MAXIMUM = -1;

    public static void setMaxTextureSize(int texSize) {
        maxTextureSize = texSize;
    }

    public static int getMaxTextureSize() {
        return maxTextureSize;
    }

    public FreeTypeFontGenerator(FileHandle font) {
        this.filePath = font.pathWithoutExtension();
        this.library = FreeType.initFreeType();
        if (this.library == null) {
            throw new GdxRuntimeException("Couldn't initialize FreeType");
        }
        this.face = FreeType.newFace(this.library, font, 0);
        if (this.face == null) {
            throw new GdxRuntimeException("Couldn't create face for font '" + font + "'");
        }
        if (this.checkForBitmapFont()) {
            return;
        }
        if (!FreeType.setPixelSizes(this.face, 0, 15)) {
            throw new GdxRuntimeException("Couldn't set size for font '" + font + "'");
        }
    }

    private boolean checkForBitmapFont() {
        FreeType.GlyphSlot slot;
        if ((this.face.getFaceFlags() & FreeType.FT_FACE_FLAG_FIXED_SIZES) == FreeType.FT_FACE_FLAG_FIXED_SIZES && (this.face.getFaceFlags() & FreeType.FT_FACE_FLAG_HORIZONTAL) == FreeType.FT_FACE_FLAG_HORIZONTAL && FreeType.loadChar(this.face, 32, FreeType.FT_LOAD_DEFAULT) && (slot = this.face.getGlyph()).getFormat() == 1651078259) {
            this.bitmapped = true;
        }
        return this.bitmapped;
    }

    public BitmapFont generateFont(int size, String characters, boolean flip) {
        FreeTypeBitmapFontData data = this.generateData(size, characters, flip, null);
        BitmapFont font = new BitmapFont((BitmapFont.BitmapFontData)data, data.getTextureRegions(), false);
        font.setOwnsTexture(true);
        return font;
    }

    public BitmapFont generateFont(int size) {
        return this.generateFont(size, DEFAULT_CHARS, false);
    }

    public int scaleForPixelHeight(int size) {
        if (!this.bitmapped && !FreeType.setPixelSizes(this.face, 0, size)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
        FreeType.SizeMetrics fontMetrics = this.face.getSize().getMetrics();
        int ascent = FreeType.toInt(fontMetrics.getAscender());
        int descent = FreeType.toInt(fontMetrics.getDescender());
        return size * size / (ascent - descent);
    }

    public GlyphAndBitmap generateGlyphAndBitmap(int c, int size, boolean flip) {
        if (!this.bitmapped && !FreeType.setPixelSizes(this.face, 0, size)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
        FreeType.SizeMetrics fontMetrics = this.face.getSize().getMetrics();
        int baseline = FreeType.toInt(fontMetrics.getAscender());
        if (FreeType.getCharIndex(this.face, c) == 0) {
            return null;
        }
        if (!FreeType.loadChar(this.face, c, FreeType.FT_LOAD_DEFAULT)) {
            throw new GdxRuntimeException("Unable to load character!");
        }
        FreeType.GlyphSlot slot = this.face.getGlyph();
        Object bitmap = this.bitmapped ? slot.getBitmap() : (!FreeType.renderGlyph(slot, FreeType.FT_RENDER_MODE_LIGHT) ? null : slot.getBitmap());
        FreeType.GlyphMetrics metrics = slot.getMetrics();
        BitmapFont.Glyph glyph = new BitmapFont.Glyph();
        if (bitmap != null) {
            glyph.width = ((FreeType.Bitmap)bitmap).getWidth();
            glyph.height = ((FreeType.Bitmap)bitmap).getRows();
        } else {
            glyph.width = 0;
            glyph.height = 0;
        }
        glyph.xoffset = slot.getBitmapLeft();
        glyph.yoffset = flip ? -slot.getBitmapTop() + baseline : -(glyph.height - slot.getBitmapTop()) - baseline;
        glyph.xadvance = FreeType.toInt(metrics.getHoriAdvance());
        glyph.srcX = 0;
        glyph.srcY = 0;
        glyph.id = c;
        GlyphAndBitmap result = new GlyphAndBitmap();
        result.glyph = glyph;
        result.bitmap = bitmap;
        return result;
    }

    public FreeTypeBitmapFontData generateData(int size) {
        return this.generateData(size, DEFAULT_CHARS, false, null);
    }

    public FreeTypeBitmapFontData generateData(int size, String characters, boolean flip) {
        return this.generateData(size, characters, flip, null);
    }

    public FreeTypeBitmapFontData generateData(int size, String characters, boolean flip, PixmapPacker packer) {
        int i;
        FreeTypeBitmapFontData data = new FreeTypeBitmapFontData();
        if (!this.bitmapped && !FreeType.setPixelSizes(this.face, 0, size)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
        FreeType.SizeMetrics fontMetrics = this.face.getSize().getMetrics();
        data.flipped = flip;
        data.ascent = FreeType.toInt(fontMetrics.getAscender());
        data.descent = FreeType.toInt(fontMetrics.getDescender());
        data.lineHeight = FreeType.toInt(fontMetrics.getHeight());
        float baseLine = data.ascent;
        if (this.bitmapped && data.lineHeight == 0.0f) {
            for (int c = 32; c < 32 + this.face.getNumGlyphs(); ++c) {
                if (!FreeType.loadChar(this.face, c, FreeType.FT_LOAD_DEFAULT)) continue;
                int lh = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
                data.lineHeight = (float)lh > data.lineHeight ? (float)lh : data.lineHeight;
            }
        }
        data.spaceWidth = FreeType.loadChar(this.face, 32, FreeType.FT_LOAD_DEFAULT) ? (float)FreeType.toInt(this.face.getGlyph().getMetrics().getHoriAdvance()) : (float)this.face.getMaxAdvanceWidth();
        BitmapFont.Glyph spaceGlyph = new BitmapFont.Glyph();
        spaceGlyph.xadvance = (int)data.spaceWidth;
        spaceGlyph.id = 32;
        data.setGlyph(32, spaceGlyph);
        for (char xChar : BitmapFont.xChars) {
            if (!FreeType.loadChar(this.face, (int)xChar, FreeType.FT_LOAD_DEFAULT)) continue;
            data.xHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
            break;
        }
        if (data.xHeight == 0.0f) {
            throw new GdxRuntimeException("No x-height character found in font");
        }
        for (char capChar : BitmapFont.capChars) {
            if (!FreeType.loadChar(this.face, (int)capChar, FreeType.FT_LOAD_DEFAULT)) continue;
            data.capHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
            break;
        }
        if (!this.bitmapped && data.capHeight == 1.0f) {
            throw new GdxRuntimeException("No cap character found in font");
        }
        data.ascent -= data.capHeight;
        data.down = -data.lineHeight;
        if (flip) {
            data.ascent = -data.ascent;
            data.down = -data.down;
        }
        boolean ownsAtlas = false;
        if (packer == null) {
            int maxGlyphHeight = (int)Math.ceil(data.lineHeight);
            int pageWidth = MathUtils.nextPowerOfTwo((int)Math.sqrt(maxGlyphHeight * maxGlyphHeight * characters.length()));
            if (maxTextureSize > 0) {
                pageWidth = Math.min(pageWidth, maxTextureSize);
            }
            ownsAtlas = true;
            packer = new PixmapPacker(pageWidth, pageWidth, Pixmap.Format.RGBA8888, 2, false);
        }
        String packPrefix = ownsAtlas ? "" : this.filePath + '_' + size + (flip ? "_flip_" : Character.valueOf('_'));
        for (i = 0; i < characters.length(); ++i) {
            char c = characters.charAt(i);
            if (!FreeType.loadChar(this.face, (int)c, FreeType.FT_LOAD_DEFAULT)) {
                Gdx.app.log("FreeTypeFontGenerator", "Couldn't load char '" + c + "'");
                continue;
            }
            if (!FreeType.renderGlyph(this.face.getGlyph(), FreeType.FT_RENDER_MODE_NORMAL)) {
                Gdx.app.log("FreeTypeFontGenerator", "Couldn't render char '" + c + "'");
                continue;
            }
            FreeType.GlyphSlot slot = this.face.getGlyph();
            FreeType.GlyphMetrics metrics = slot.getMetrics();
            FreeType.Bitmap bitmap = slot.getBitmap();
            Pixmap pixmap = bitmap.getPixmap(Pixmap.Format.RGBA8888);
            BitmapFont.Glyph glyph = new BitmapFont.Glyph();
            glyph.id = c;
            glyph.width = pixmap.getWidth();
            glyph.height = pixmap.getHeight();
            glyph.xoffset = slot.getBitmapLeft();
            glyph.yoffset = flip ? -slot.getBitmapTop() + (int)baseLine : -(glyph.height - slot.getBitmapTop()) - (int)baseLine;
            glyph.xadvance = FreeType.toInt(metrics.getHoriAdvance());
            if (this.bitmapped) {
                pixmap.setColor(Color.CLEAR);
                pixmap.fill();
                ByteBuffer buf = bitmap.getBuffer();
                for (int h = 0; h < glyph.height; ++h) {
                    int idx = h * bitmap.getPitch();
                    for (int w = 0; w < glyph.width + glyph.xoffset; ++w) {
                        int bit = buf.get(idx + w / 8) >>> 7 - w % 8 & 1;
                        pixmap.drawPixel(w, h, bit == 1 ? Color.WHITE.toIntBits() : Color.CLEAR.toIntBits());
                    }
                }
            }
            String name = packPrefix + c;
            Rectangle rect = packer.pack(name, pixmap);
            int pIndex = packer.getPageIndex(name);
            if (pIndex == -1) {
                throw new IllegalStateException("packer was not able to insert '" + name + "' into a page");
            }
            glyph.page = pIndex;
            glyph.srcX = (int)rect.x;
            glyph.srcY = (int)rect.y;
            data.setGlyph(c, glyph);
            pixmap.dispose();
        }
        for (i = 0; i < characters.length(); ++i) {
            for (int j = 0; j < characters.length(); ++j) {
                int kerning;
                char secondChar;
                BitmapFont.Glyph second;
                char firstChar = characters.charAt(i);
                BitmapFont.Glyph first = data.getGlyph(firstChar);
                if (first == null || (second = data.getGlyph(secondChar = characters.charAt(j))) == null || (kerning = FreeType.getKerning(this.face, FreeType.getCharIndex(this.face, (int)firstChar), FreeType.getCharIndex(this.face, (int)secondChar), 0)) == 0) continue;
                first.setKerning(secondChar, FreeType.toInt(kerning));
            }
        }
        if (ownsAtlas) {
            Array<PixmapPacker.Page> pages = packer.getPages();
            data.regions = new TextureRegion[pages.size];
            for (int i2 = 0; i2 < pages.size; ++i2) {
                PixmapPacker.Page p = pages.get(i2);
                Texture tex = new Texture(p.getPixmap(), p.getPixmap().getFormat(), false);
                tex.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
                data.regions[i2] = new TextureRegion(tex);
            }
            packer.dispose();
        }
        return data;
    }

    @Override
    public void dispose() {
        FreeType.doneFace(this.face);
        FreeType.doneFreeType(this.library);
    }

    public static class FreeTypeBitmapFontData
    extends BitmapFont.BitmapFontData {
        TextureRegion[] regions;

        @Deprecated
        public TextureRegion getTextureRegion() {
            return this.regions[0];
        }

        public TextureRegion[] getTextureRegions() {
            return this.regions;
        }
    }

    public class GlyphAndBitmap {
        public BitmapFont.Glyph glyph;
        public FreeType.Bitmap bitmap;
    }
}

