/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;

public class PolygonRegionLoader {
    private EarClippingTriangulator triangulator = new EarClippingTriangulator();

    public PolygonRegion load(TextureRegion textureRegion, FileHandle file) {
        BufferedReader reader = file.reader(256);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("s")) continue;
                String[] polygonStrings = line.substring(1).trim().split(",");
                float[] vertices = new float[polygonStrings.length];
                int n = vertices.length;
                for (int i = 0; i < n; ++i) {
                    vertices[i] = Float.parseFloat(polygonStrings[i]);
                }
                PolygonRegion polygonRegion = new PolygonRegion(textureRegion, vertices, this.triangulator.computeTriangles(vertices).toArray());
                return polygonRegion;
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading polygon shape file: " + file, ex);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
        throw new GdxRuntimeException("Polygon shape not found: " + file);
    }
}

