/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.openal;

import com.badlogic.gdx.backends.openal.OggInputStream;
import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.backends.openal.OpenALMusic;
import com.badlogic.gdx.backends.openal.OpenALSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.ByteArrayOutputStream;

public class Ogg {

    public static class Sound
    extends OpenALSound {
        public Sound(OpenALAudio audio, FileHandle file) {
            super(audio);
            int length;
            if (audio.noDevice) {
                return;
            }
            OggInputStream input = new OggInputStream(file.read());
            ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[2048];
            while (!input.atEnd() && (length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            this.setup(output.toByteArray(), input.getChannels(), input.getSampleRate());
        }
    }

    public static class Music
    extends OpenALMusic {
        private OggInputStream input;

        public Music(OpenALAudio audio, FileHandle file) {
            super(audio, file);
            if (audio.noDevice) {
                return;
            }
            this.input = new OggInputStream(file.read());
            this.setup(this.input.getChannels(), this.input.getSampleRate());
        }

        @Override
        public int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new OggInputStream(this.file.read());
                this.setup(this.input.getChannels(), this.input.getSampleRate());
            }
            return this.input.read(buffer);
        }

        @Override
        public void reset() {
            StreamUtils.closeQuietly(this.input);
            this.input = null;
        }
    }
}

