/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Matrix4;
import walnoot.libgdxutils.State;

public abstract class AnimatedState
extends State {
    private FrameBuffer frameBuffer;
    private SpriteBatch batch = new SpriteBatch(1);
    private Transition transition = this.getTransition();
    private float progress = 0.0f;
    private boolean updateInTransition;

    public AnimatedState() {
        this(false);
    }

    public AnimatedState(boolean updateInTransition) {
        this.updateInTransition = updateInTransition;
    }

    @Override
    public void show() {
        Matrix4 projection = new Matrix4();
        projection.setToOrtho2D(0.0f, 1.0f, 1.0f, -1.0f);
        this.batch.setProjectionMatrix(projection);
    }

    @Override
    public final void update() {
        if (this.updateInTransition) {
            this.updateLogic();
        }
        if (!this.shouldFadeOut()) {
            this.progress += this.getDelta() / this.getDuration();
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
                if (!this.updateInTransition) {
                    this.updateLogic();
                }
            }
        } else {
            this.progress -= this.getDelta() / this.getDuration();
            if (this.progress < 0.0f) {
                this.progress = 0.0f;
                this.onFadeOut();
            }
        }
        this.transition.progress = this.progress;
    }

    @Override
    public void render() {
        this.manager.getRenderContext().setCurrentTarget(this.frameBuffer);
        this.renderScene();
        this.manager.getRenderContext().endCurruntTarget();
        this.batch.begin();
        this.batch.setColor(1.0f, 1.0f, 1.0f, this.transition.getAlpha());
        this.batch.draw((Texture)this.frameBuffer.getColorBufferTexture(), this.transition.getX(), this.transition.getY(), 1.0f, 1.0f);
        this.batch.end();
    }

    protected abstract void renderScene();

    protected void updateLogic() {
    }

    protected float getDuration() {
        return 1.0f;
    }

    protected boolean shouldFadeOut() {
        return false;
    }

    protected void onFadeOut() {
    }

    protected Transition getTransition() {
        return new Transition(0.0f, -1.0f, 0.0f, Interpolation.sine);
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        if (this.frameBuffer != null) {
            this.frameBuffer.dispose();
        }
        this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
    }

    @Override
    public void hide() {
        if (this.frameBuffer != null) {
            this.frameBuffer.dispose();
        }
        this.frameBuffer = null;
    }

    public static class Transition {
        private float startX = 0.0f;
        private float startY = 0.0f;
        private float startAlpha = 0.0f;
        private Interpolation interpolation = Interpolation.linear;
        private float progress;

        public Transition() {
        }

        public Transition(float startX, float startY, float startAlpha, Interpolation interpolation) {
            this.startX = startX;
            this.startY = startY;
            this.startAlpha = startAlpha;
            this.interpolation = interpolation;
        }

        public float getX() {
            return this.interpolation.apply(this.startX, 0.0f, this.progress);
        }

        public float getY() {
            return this.interpolation.apply(this.startY, 0.0f, this.progress);
        }

        public float getAlpha() {
            return this.interpolation.apply(this.startAlpha, 1.0f, this.progress);
        }
    }
}

