/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace.components;

import com.badlogic.gdx.physics.box2d.Contact;
import me.walnoot.lifeinspace.Component;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.components.EnemyComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;

public class WarpgateComponent
extends Component {
    private boolean inZone;
    private boolean enemyNearby;

    @Override
    public void update() {
        this.enemyNearby = false;
        if (this.inZone) {
            this.world.queryRadius(this.body.getPosition(), 50.0f, e -> {
                if (e.has(EnemyComponent.class)) {
                    this.enemyNearby = true;
                }
            });
        }
    }

    @Override
    public void beginContact(Contact contact, Entity other) {
        if (this.hitsWarpzone(contact, other)) {
            this.inZone = true;
        }
    }

    @Override
    public void endContact(Contact contact, Entity other) {
        if (this.hitsWarpzone(contact, other)) {
            this.inZone = false;
        }
    }

    private boolean hitsWarpzone(Contact contact, Entity other) {
        boolean b;
        boolean a = contact.getFixtureA().isSensor() && contact.getFixtureA().getBody() == this.body;
        boolean bl = b = contact.getFixtureB().isSensor() && contact.getFixtureB().getBody() == this.body;
        return other.has(PlayerComponent.class) && (a || b);
    }

    public boolean isWarping() {
        return this.inZone && !this.enemyNearby;
    }

    public boolean isEnemyNearby() {
        return this.enemyNearby;
    }
}

