/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace.components;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import me.walnoot.lifeinspace.Assets;
import me.walnoot.lifeinspace.Component;
import me.walnoot.lifeinspace.CrewMember;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.Item;
import me.walnoot.lifeinspace.components.BulletComponent;
import me.walnoot.lifeinspace.components.HealthComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;
import me.walnoot.lifeinspace.components.SpritesComponent;

public class ShipComponent
extends Component
implements HealthComponent.HealthListener {
    public static final float BASE_TORQUE = 25.0f;
    public static final float BASE_FORCE = 25.0f;
    private static final float THRESHOLD_SPEED = 10.0f;
    private static final float CREW_HURT_CHANCE = 0.5f;
    private static final int CREW_DAMAGE_SPREAD = 2;
    private static final int CREW_BASE_DAMAGE = 10;
    private float forwardForce = 25.0f;
    private float rotTorque = 25.0f;
    private float gunDamage = 1.0f;
    private float gunFireRate = 0.5f;
    private Vector2 tmp1 = new Vector2();
    private Vector2 tmp2 = new Vector2();
    private float fireTimer;
    private boolean movForward;
    private boolean movLeft;
    private boolean movRight;
    private Array<Item> items = new Array();
    private ObjectMap<CrewMember.Task, CrewMember> crew = new ObjectMap();
    private Sound engine = Assets.sounds.get("sounds/engine");
    private long soundId = -1L;

    public ShipComponent() {
        this.addMember(new CrewMember(CrewMember.Task.PILOT));
        this.addMember(new CrewMember(CrewMember.Task.GUNNER));
    }

    @Override
    public void update() {
        this.fireTimer += 0.016666668f;
        if (this.e.has(PlayerComponent.class)) {
            if (this.soundId == -1L) {
                this.soundId = this.engine.loop();
            }
            if (this.movForward) {
                this.engine.resume(this.soundId);
            } else {
                this.engine.pause(this.soundId);
            }
        }
        if (this.e.has(SpritesComponent.class)) {
            SpritesComponent sprites = this.e.get(SpritesComponent.class);
            if (sprites.sprites.size >= 4) {
                sprites.sprites.get(1).setAlpha(this.movForward ? 1.0f : 0.0f);
                sprites.sprites.get(2).setAlpha(this.movRight ? 1.0f : 0.0f);
                sprites.sprites.get(3).setAlpha(this.movLeft ? 1.0f : 0.0f);
                this.movForward = false;
                this.movLeft = false;
                this.movRight = false;
            }
        }
        this.gunDamage = 1.0f;
        this.gunFireRate = 1.0f;
        this.forwardForce = 25.0f;
        for (Item i : this.items) {
            this.gunDamage = i.traits.get(Item.ItemTrait.GUN_DAMAGE, Float.valueOf(this.gunDamage)).floatValue();
            this.gunFireRate = i.traits.get(Item.ItemTrait.GUN_FIRERATE, Float.valueOf(this.gunFireRate)).floatValue();
            this.forwardForce = i.traits.get(Item.ItemTrait.ENGINE_FORCE, Float.valueOf(this.forwardForce)).floatValue();
        }
        Vector2 vel = this.body.getLinearVelocity();
        float damping = Math.max(0.0f, (vel.len() - 10.0f) * 0.5f);
        this.body.applyForceToCenter(-vel.x * damping, -vel.y * damping, false);
    }

    @Override
    public void newComponent(Component c) {
        if (c instanceof HealthComponent) {
            ((HealthComponent)c).addListener(this);
        }
    }

    @Override
    public void onHit(float damage) {
        for (CrewMember c : this.crew.values()) {
            if (!MathUtils.randomBoolean(0.5f)) continue;
            int min = 8;
            int max = 12;
            c.setHealth(c.getHealth() - MathUtils.random(min, max));
            if (c.getHealth() >= 0) continue;
            this.crew.remove(c.getTask());
        }
    }

    public void addMember(CrewMember c) {
        this.crew.put(c.getTask(), c);
    }

    public CrewMember getMember(CrewMember.Task t) {
        return this.crew.get(t);
    }

    public void moveForward() {
        this.tmp1.set(0.0f, this.forwardForce).rotateRad(this.body.getAngle());
        this.body.applyForceToCenter(this.tmp1.x, this.tmp1.y, true);
        this.movForward = true;
    }

    public void moveBackward() {
        this.tmp1.set(0.0f, -this.forwardForce).rotateRad(this.body.getAngle());
        this.body.applyForceToCenter(this.tmp1.x, this.tmp1.y, true);
    }

    public void moveLeft() {
        this.body.applyTorque(this.rotTorque, true);
        this.movLeft = true;
    }

    public void moveRight() {
        this.body.applyTorque(-this.rotTorque, true);
        this.movRight = true;
    }

    public void fire() {
        if (this.fireTimer > 1.0f / this.gunFireRate) {
            this.fireTimer = 0.0f;
            Entity entity = this.world.addEntity("bullet");
            entity.get(BulletComponent.class).damage = this.gunDamage;
            this.tmp1.set(0.0f, 1.0f).rotateRad(this.body.getAngle());
            this.tmp2.set(0.0f, 0.0f).add(this.tmp1).scl(2.5f).add(this.body.getPosition());
            this.tmp1.scl(30.0f);
            entity.getBody().setTransform(this.tmp2, this.body.getAngle());
            entity.getBody().setLinearVelocity(this.tmp1);
        }
    }

    public Item equip(Item item) {
        Item current = null;
        for (Item i : this.items) {
            if (i.itemClass != item.itemClass) continue;
            current = i;
        }
        this.items.removeValue(current, true);
        this.items.add(item);
        return current;
    }

    public Array<Item> getItems() {
        return this.items;
    }

    public Item getItem(Item.ItemClass itemClass) {
        for (Item i : this.items) {
            if (i.itemClass != itemClass) continue;
            return i;
        }
        return null;
    }
}

