/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace.components;

import com.badlogic.gdx.Gdx;
import me.walnoot.lifeinspace.Component;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.Item;
import me.walnoot.lifeinspace.components.ItemComponent;
import me.walnoot.lifeinspace.components.ShipComponent;

public class PlayerComponent
extends Component {
    public static final float PICKUP_RADIUS = 10.0f;
    private float nearestItemDst2;
    private Entity nearestItem;

    @Override
    public void update() {
        Entity item;
        ShipComponent ship = this.e.get(ShipComponent.class);
        if (Gdx.input.isKeyPressed(51)) {
            ship.moveForward();
        }
        if (Gdx.input.isKeyPressed(29)) {
            ship.moveLeft();
        }
        if (Gdx.input.isKeyPressed(32)) {
            ship.moveRight();
        }
        if (Gdx.input.isKeyPressed(62)) {
            ship.fire();
        }
        if (Gdx.input.isKeyJustPressed(33) && (item = this.getNearestPickup()) != null) {
            Item newItem = item.get(ItemComponent.class).item;
            Item oldItem = ship.getItem(newItem.itemClass);
            ship.equip(newItem);
            if (oldItem == null) {
                this.world.removeEntity(item);
            } else {
                item.get(ItemComponent.class).item = oldItem;
            }
        }
    }

    public Entity getNearestPickup() {
        this.nearestItemDst2 = Float.MAX_VALUE;
        this.nearestItem = null;
        this.world.queryRadius(this.body.getPosition(), 10.0f, e -> {
            float dst2;
            if (e.has(ItemComponent.class) && (dst2 = e.getBody().getPosition().dst2(this.body.getPosition())) < this.nearestItemDst2) {
                this.nearestItemDst2 = dst2;
                this.nearestItem = e;
            }
        });
        return this.nearestItem;
    }
}

