/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace.components;

import com.badlogic.gdx.utils.Array;
import me.walnoot.lifeinspace.Component;
import me.walnoot.lifeinspace.components.PlayerComponent;

public class HealthComponent
extends Component {
    private float maxHealth;
    private float health;
    private Array<HealthListener> listeners = new Array();

    public HealthComponent(float maxHealth) {
        this.maxHealth = maxHealth;
        this.health = maxHealth;
    }

    private float add(float amount) {
        float oldHealth = this.health;
        this.health += amount;
        if (this.health <= 0.0f) {
            this.health = 0.0f;
            this.world.removeEntity(this.e);
        }
        if (this.health > this.maxHealth) {
            this.health = this.maxHealth;
        }
        return this.health - oldHealth;
    }

    public float hit(float damage) {
        System.out.printf("damage: %.2f, player=%b\n", Float.valueOf(damage), this.e.has(PlayerComponent.class));
        float actualDamage = -this.add(-damage);
        for (HealthListener l : this.listeners) {
            l.onHit(actualDamage);
        }
        return actualDamage;
    }

    public float heal(float amount) {
        return this.add(amount);
    }

    public void addListener(HealthListener l) {
        this.listeners.add(l);
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
        this.health = maxHealth;
    }

    public static interface HealthListener {
        public void onHit(float var1);
    }
}

