/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import me.walnoot.lifeinspace.Component;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.Item;
import me.walnoot.lifeinspace.components.ItemComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;
import me.walnoot.lifeinspace.components.ShipComponent;
import me.walnoot.lifeinspace.components.SpritesComponent;

public class EnemyComponent
extends Component {
    private static final float NORMAL_SEARCH_RADIUS = 40.0f;
    private static final float ALERT_SEARCH_RADIUS = 80.0f;
    private Vector2 tmp1 = new Vector2();
    private Vector2 tmp2 = new Vector2();
    float searchRadius = 40.0f;

    @Override
    public void update() {
        this.e.get(SpritesComponent.class).setColors(Color.GRAY);
        this.world.queryRadius(this.body.getPosition(), this.searchRadius, e -> {
            if (e.has(PlayerComponent.class)) {
                this.searchRadius = 80.0f;
                this.tmp1.set(0.0f, 1.0f).rotateRad(this.body.getAngle());
                this.tmp2.set(this.body.getPosition()).sub(e.getBody().getPosition()).nor();
                float angleDiff = this.tmp1.crs(this.tmp2);
                this.turnTowards((Entity)e, angleDiff);
                if (e.getBody().getPosition().dst2(this.body.getPosition()) > 225.0f) {
                    this.moveTowards((Entity)e, angleDiff);
                }
                this.checkFire((Entity)e, angleDiff);
            }
        });
    }

    private void checkFire(Entity player, float angleDiff) {
        if (Math.abs(angleDiff * 57.295776f) < 20.0f) {
            this.e.get(ShipComponent.class).fire();
        }
    }

    private void moveTowards(Entity player, float angleDiff) {
        if (Math.abs(angleDiff * 57.295776f) < 20.0f) {
            this.e.get(ShipComponent.class).moveForward();
        }
    }

    private void turnTowards(Entity player, float angleDiff) {
        ShipComponent ship = this.e.get(ShipComponent.class);
        if (angleDiff > 0.0f && this.body.getAngularVelocity() > -1.5f * angleDiff) {
            ship.moveRight();
        }
        if (angleDiff < 0.0f && this.body.getAngularVelocity() < -1.5f * angleDiff) {
            ship.moveLeft();
        }
    }

    @Override
    public void onRemove() {
        if (MathUtils.randomBoolean(0.5f)) {
            Entity gun = this.world.addEntity("gun");
            gun.get(ItemComponent.class).item = this.e.get(ShipComponent.class).getItem(Item.ItemClass.GUN);
            gun.getBody().setTransform(this.body.getPosition(), this.body.getAngle());
            gun.getBody().setLinearVelocity(this.body.getLinearVelocity());
            gun.getBody().setAngularVelocity(this.body.getAngularVelocity());
        }
    }
}

