/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import me.walnoot.lifeinspace.Assets;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.GameWorld;
import me.walnoot.lifeinspace.Item;
import me.walnoot.lifeinspace.Util;
import me.walnoot.lifeinspace.components.EnemyComponent;
import me.walnoot.lifeinspace.components.HealthComponent;
import me.walnoot.lifeinspace.components.ItemComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;
import me.walnoot.lifeinspace.components.ShipComponent;
import me.walnoot.lifeinspace.components.SpritesComponent;
import me.walnoot.lifeinspace.components.WarpgateComponent;

public class WorldRenderer {
    private static final float SECTOR_SIZE = 40.0f;
    private final GameWorld world;
    private float[] randoms = new float[73];
    private Box2DDebugRenderer debug = new Box2DDebugRenderer();
    private SpriteBatch batch = new SpriteBatch();
    private ShapeRenderer shape = new ShapeRenderer();
    private OrthographicCamera camera = new OrthographicCamera();
    private OrthographicCamera uiCamera = new OrthographicCamera();
    private Array<Sprite> sprites = new Array();
    private Sprite starSprite;
    private Sprite healthBar;
    private Sprite healthBarFrame;
    private float healthBarU2;
    private Entity player;
    private float lastHealth = 0.0f;
    private float shakeTimer;
    private float timer;
    private StringBuilder builder = new StringBuilder();
    private GlyphLayout layout = new GlyphLayout();
    private Vector2 tmp = new Vector2();

    public WorldRenderer(GameWorld world) {
        this.world = world;
        this.starSprite = world.getLoader().getAtlas().createSprite("star");
        this.healthBarFrame = world.getLoader().getAtlas().createSprite("healthbarframe");
        this.healthBar = world.getLoader().getAtlas().createSprite("healthbar");
        this.healthBarU2 = this.healthBar.getU2();
        int i = 0;
        while (i < this.randoms.length) {
            this.randoms[i] = MathUtils.random();
            ++i;
        }
    }

    public void render(float warpTime, int difficulty) {
        this.timer += Gdx.graphics.getDeltaTime();
        boolean blink = this.timer % 1.0f > 0.5f;
        this.shakeTimer -= Gdx.graphics.getDeltaTime();
        if (this.shakeTimer < 0.0f) {
            this.shakeTimer = 0.0f;
        }
        this.player = null;
        this.world.forAllEntities(e -> {
            if (e.has(PlayerComponent.class)) {
                if (e.has(HealthComponent.class)) {
                    float health = e.get(HealthComponent.class).getHealth();
                    if (health < this.lastHealth) {
                        this.shakeTimer = 1.0f;
                    }
                    this.lastHealth = health;
                }
                this.camera.position.x = e.getX();
                this.camera.position.y = e.getY();
                this.camera.position.x += MathUtils.random() * this.shakeTimer;
                this.camera.position.y += MathUtils.random() * this.shakeTimer;
                this.player = e;
            }
        });
        this.camera.zoom = (float)(16.0 + Math.pow(1000.0, warpTime));
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        if (this.camera.zoom < 50.0f) {
            this.renderBackground();
        }
        this.sprites.clear();
        this.world.forAllEntities(e -> {
            if (e.has(SpritesComponent.class)) {
                for (Sprite s : e.get(SpritesComponent.class).sprites) {
                    s.setOrigin(s.getWidth() / 2.0f, s.getHeight() / 2.0f);
                    s.setCenter(e.getX(), e.getY());
                    s.setRotation(e.getBody().getAngle() * 57.295776f);
                    this.sprites.add(s);
                }
            }
        });
        for (Sprite s : this.sprites) {
            s.draw(this.batch);
        }
        if (this.player != null) {
            PlayerComponent playerComponent = this.player.get(PlayerComponent.class);
            Entity nearestPickup = playerComponent.getNearestPickup();
            float sWidth = this.camera.viewportWidth * this.camera.zoom * 0.5f - 1.0f;
            float sHeight = this.camera.viewportHeight * this.camera.zoom * 0.5f - 1.0f;
            this.world.queryRadius(this.player.getBody().getPosition(), 30.0f, e -> {
                this.builder.length = 0;
                if (e.has(EnemyComponent.class)) {
                    this.builder.append("[GRAY]Class ");
                    this.builder.append((char)(65 + difficulty - 1));
                    this.builder.append(" enemy[]\n");
                    this.builder.append("Hull: [RED][[");
                    HealthComponent hComponent = e.get(HealthComponent.class);
                    float f3 = hComponent.getHealth() / hComponent.getMaxHealth();
                    this.builder.append(MathUtils.floor(f3 * 100.0f), 3);
                    this.builder.append("%][]");
                    this.layout.setText(Assets.font, this.builder);
                }
                if (e.has(ItemComponent.class) && e.getBody().getPosition().dst(this.camera.position.x, this.camera.position.y) < 10.0f) {
                    Item item = e.get(ItemComponent.class).item;
                    this.builder.append(item.name);
                    this.builder.append("\n");
                    for (ObjectMap.Entry entry : item.traits) {
                        this.builder.append(entry.key);
                        this.builder.append(": ");
                        ((Item.ItemTrait)((Object)((Object)entry.key))).appendValue(this.builder, ((Float)entry.value).floatValue());
                        this.builder.append("\n");
                    }
                    if (e == nearestPickup) {
                        this.builder.append("Press [GREEN]E[] to swap");
                    }
                }
                this.tmp.set(e.getBody().getPosition()).sub(this.camera.position.x, this.camera.position.y);
                if (this.tmp.x > sWidth - this.layout.width) {
                    this.tmp.x = sWidth - this.layout.width;
                }
                if (this.tmp.x < -sWidth) {
                    this.tmp.x = -sWidth;
                }
                if (this.tmp.y > sHeight - this.layout.height - 1.0f) {
                    this.tmp.y = sHeight - this.layout.height - 1.0f;
                }
                if (this.tmp.y < -sHeight) {
                    this.tmp.y = -sHeight;
                }
                this.tmp.add(this.player.getBody().getPosition());
                Assets.font.draw((Batch)this.batch, this.builder, this.tmp.x, this.tmp.y + 3.0f);
            });
            this.builder.length = 0;
            this.builder.append("\n[GRAY]Ship Status:[]\n");
            for (Item item : this.player.get(ShipComponent.class).getItems()) {
                this.builder.append(item.itemClass.name);
                this.builder.append(": ");
                this.builder.append(item.name);
                this.builder.append("\n");
            }
            this.builder.append("\nCurrent Sector: [GREEN][");
            this.appendSector(this.player);
            this.builder.append("[]\n");
            this.world.forAllEntities(e -> {
                if (e.has(WarpgateComponent.class)) {
                    this.builder.append("Gate Sector: [BLUE][");
                    this.appendSector((Entity)e);
                    this.builder.append("[]\n");
                    if (e.get(WarpgateComponent.class).isEnemyNearby()) {
                        this.builder.append(blink ? "[RED]" : "[WHITE]");
                        this.builder.append("Can't warp; enemies nearby[]");
                    }
                }
            });
            Assets.font.draw((Batch)this.batch, this.builder, -sWidth + this.camera.position.x, sHeight + this.camera.position.y);
        }
        this.batch.setProjectionMatrix(this.uiCamera.combined);
        this.renderUI();
        this.batch.end();
        Gdx.gl.glEnable(3042);
        this.shape.setProjectionMatrix(this.uiCamera.combined);
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(0.0f, 0.0f, 0.0f, warpTime);
        float uiWidth = this.uiCamera.viewportWidth;
        float uiHeight = this.uiCamera.viewportHeight;
        this.shape.rect(-uiWidth * 0.5f, -uiHeight * 0.5f, uiWidth, uiHeight);
        this.shape.end();
        Gdx.gl.glDisable(3042);
    }

    private void appendSector(Entity e) {
        int sx = MathUtils.floor(e.getX() / 40.0f);
        int sy = MathUtils.floor(e.getY() / 40.0f);
        this.builder.append("[");
        if (sx >= 0) {
            this.builder.append("+");
        }
        this.builder.append(sx, 2);
        this.builder.append(",");
        if (sy >= 0) {
            this.builder.append("+");
        }
        this.builder.append(sy, 2);
        this.builder.append("]");
    }

    private void renderBackground() {
        float x1 = this.camera.position.x - this.camera.viewportWidth * this.camera.zoom;
        float x2 = this.camera.position.x + this.camera.viewportWidth * this.camera.zoom;
        float y1 = this.camera.position.y - this.camera.viewportHeight * this.camera.zoom;
        float y2 = this.camera.position.y + this.camera.viewportHeight * this.camera.zoom;
        int x = MathUtils.floor(x1);
        while (x <= MathUtils.ceil(x2)) {
            int y = MathUtils.floor(y1);
            while (y <= MathUtils.ceil(y2)) {
                if (x % 4 == 0 && y % 4 == 0) {
                    float randx = this.randoms[Util.wrap(x + y * 20, this.randoms.length)];
                    float randy = this.randoms[Util.wrap(x + y * 20 + 20, this.randoms.length)];
                    float size = this.randoms[Util.wrap(x + y * 20 + 40, this.randoms.length)] * 0.5f + 0.2f;
                    this.starSprite.setSize(size, size);
                    this.starSprite.setOrigin(size / 2.0f, size / 2.0f);
                    this.starSprite.setCenter((float)x + randx * 4.0f, (float)y + randy * 4.0f);
                    this.starSprite.setRotation(randx * 720.0f);
                    this.starSprite.draw(this.batch);
                }
                ++y;
            }
            ++x;
        }
    }

    private void renderUI() {
        if (this.player != null && this.player.has(HealthComponent.class)) {
            float x = 0.1015625f;
            HealthComponent health = this.player.get(HealthComponent.class);
            float ratio = MathUtils.lerp(x, 1.0f - x, health.getHealth() / health.getMaxHealth());
            this.healthBar.setSize(0.6f * ratio, 0.3f);
            this.healthBar.setPosition(-0.3f, -1.0f);
            this.healthBar.setU2(this.healthBarU2 - (this.healthBarU2 - this.healthBar.getU()) * (1.0f - ratio));
            this.healthBar.draw(this.batch);
            this.healthBarFrame.setSize(0.6f, 0.3f);
            this.healthBarFrame.setCenter(0.0f, -1.0f + this.healthBarFrame.getHeight() / 2.0f);
            this.healthBarFrame.draw(this.batch);
        }
    }

    public void resize(int width, int height) {
        this.camera.viewportHeight = 2.0f;
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.zoom = 16.0f;
        this.uiCamera.viewportHeight = 2.0f;
        this.uiCamera.viewportWidth = 2.0f * (float)width / (float)height;
        this.uiCamera.zoom = 1.0f;
    }
}

