/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import me.walnoot.lifeinspace.Assets;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.components.BodyDefComponent;
import me.walnoot.lifeinspace.components.BulletComponent;
import me.walnoot.lifeinspace.components.EnemyComponent;
import me.walnoot.lifeinspace.components.FixturesComponent;
import me.walnoot.lifeinspace.components.HealthComponent;
import me.walnoot.lifeinspace.components.ItemComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;
import me.walnoot.lifeinspace.components.ShipComponent;
import me.walnoot.lifeinspace.components.SoundComponent;
import me.walnoot.lifeinspace.components.SpritesComponent;
import me.walnoot.lifeinspace.components.WarpgateComponent;

public class PrototypeLoader {
    private ObjectMap<String, JsonValue> prototypes = new ObjectMap();
    private TextureAtlas atlas;
    private Json json = new Json();

    public PrototypeLoader(TextureAtlas atlas) {
        this.atlas = atlas;
        JsonValue protos = new JsonReader().parse(Gdx.files.internal("proto.json"));
        JsonValue proto = protos.child;
        while (proto != null) {
            this.prototypes.put(proto.name, proto);
            proto = proto.next;
        }
        this.json.setSerializer(Shape.class, new Json.ReadOnlySerializer<Shape>(){

            @Override
            public Shape read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.getString(0).equals("box")) {
                    PolygonShape box = new PolygonShape();
                    Vector2 pos = new Vector2();
                    if (jsonData.get(4) != null) {
                        pos.set(jsonData.getFloat(3), jsonData.getFloat(4));
                    }
                    box.setAsBox(jsonData.getFloat(1), jsonData.getFloat(2), pos, 0.0f);
                    return box;
                }
                if (jsonData.getString(0).equals("circle")) {
                    CircleShape circle = new CircleShape();
                    circle.setRadius(jsonData.getFloat(1));
                    return circle;
                }
                return null;
            }
        });
        this.json.setSerializer(Sound.class, new Json.ReadOnlySerializer<Sound>(){

            @Override
            public Sound read(Json json, JsonValue jsonData, Class type) {
                return Assets.sounds.get(jsonData.asString(), null);
            }
        });
    }

    public Entity createProto(String name) {
        Entity entity = new Entity();
        JsonValue component = this.prototypes.get((String)name).child;
        while (component != null) {
            switch (component.name) {
                case "player": {
                    entity.addComponent(new PlayerComponent());
                    break;
                }
                case "bullet": {
                    entity.addComponent(new BulletComponent());
                    break;
                }
                case "health": {
                    entity.addComponent(new HealthComponent(component.asInt()));
                    break;
                }
                case "enemy": {
                    entity.addComponent(new EnemyComponent());
                    break;
                }
                case "ship": {
                    entity.addComponent(this.json.readValue(ShipComponent.class, component));
                    break;
                }
                case "warpgate": {
                    entity.addComponent(new WarpgateComponent());
                    break;
                }
                case "item": {
                    entity.addComponent(new ItemComponent());
                    break;
                }
                case "sound": {
                    entity.addComponent(this.json.readValue(SoundComponent.class, component));
                    break;
                }
                case "bodyDef": {
                    BodyDef def = BodyDefComponent.getDefaultDef();
                    this.json.readFields(def, component);
                    entity.addComponent(new BodyDefComponent(def));
                    break;
                }
                case "fixtures": {
                    FixturesComponent fixtures = new FixturesComponent();
                    JsonValue fixture = component.child;
                    while (fixture != null) {
                        FixtureDef fdef = FixturesComponent.getDefaultFixture();
                        this.json.readFields(fdef, fixture);
                        fixtures.fixtures.add(fdef);
                        fixture = fixture.next;
                    }
                    entity.addComponent(fixtures);
                    break;
                }
                case "sprites": {
                    SpritesComponent spritesComponent = new SpritesComponent();
                    JsonValue sprite = component.child;
                    while (sprite != null) {
                        Sprite s = this.atlas.createSprite(sprite.getString(0));
                        s.setSize(sprite.getFloat(1), sprite.getFloat(2));
                        spritesComponent.sprites.add(s);
                        sprite = sprite.next;
                    }
                    entity.addComponent(spritesComponent);
                    break;
                }
                default: {
                    System.out.println("Unknown component type: " + component.name);
                }
            }
            component = component.next;
        }
        return entity;
    }

    public TextureAtlas getAtlas() {
        return this.atlas;
    }
}

