/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.physics.box2d.Box2D;
import com.badlogic.gdx.utils.Array;
import java.util.Scanner;
import me.walnoot.lifeinspace.Assets;
import me.walnoot.lifeinspace.GameState;
import me.walnoot.lifeinspace.PrototypeLoader;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.StateApplication;

public class LifeInSpaceGame
extends StateApplication {
    public static final boolean DEBUG = true;
    public static final float FPS = 60.0f;
    public static final float DELTA = 0.016666668f;
    private Array<String> assets = new Array();

    public LifeInSpaceGame() {
        super(60.0f, true);
    }

    @Override
    protected void init() {
        Scanner scanner = new Scanner(Gdx.files.internal("filelist").read());
        while (scanner.hasNextLine()) {
            this.assets.add(scanner.nextLine());
        }
        scanner.close();
        PixmapPacker packer = new PixmapPacker(1024, 1024, Pixmap.Format.RGBA8888, 2, true);
        for (String file : this.assets) {
            if (file.endsWith(".png")) {
                packer.pack(file.substring(0, file.length() - 4), new Pixmap(Gdx.files.internal(file)));
            }
            if (!file.endsWith(".wav")) continue;
            Assets.sounds.put(file.substring(0, file.length() - 4), Gdx.audio.newSound(Gdx.files.internal(file)));
        }
        Assets.atlas = packer.generateTextureAtlas(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, true);
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("VeraMono.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.genMipMaps = true;
        parameter.minFilter = Texture.TextureFilter.MipMapLinearLinear;
        parameter.magFilter = Texture.TextureFilter.Linear;
        parameter.size = 32;
        parameter.packer = packer;
        parameter.borderWidth = 2.0f;
        Assets.font = generator.generateFont(parameter);
        Assets.font.setUseIntegerPositions(false);
        Assets.font.getData().markupEnabled = true;
        Assets.font.getData().setScale(0.75f / (float)parameter.size);
        Box2D.init();
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        super.render();
    }

    @Override
    protected State getFirstState() {
        return new GameState(new PrototypeLoader(Assets.atlas));
    }
}

