/*
 * Decompiled with CFR 0.152.
 */
package me.walnoot.lifeinspace;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.MathUtils;
import me.walnoot.lifeinspace.Assets;
import me.walnoot.lifeinspace.Entity;
import me.walnoot.lifeinspace.GameWorld;
import me.walnoot.lifeinspace.PrototypeLoader;
import me.walnoot.lifeinspace.Util;
import me.walnoot.lifeinspace.WorldRenderer;
import me.walnoot.lifeinspace.components.HealthComponent;
import me.walnoot.lifeinspace.components.PlayerComponent;
import me.walnoot.lifeinspace.components.ShipComponent;
import me.walnoot.lifeinspace.components.WarpgateComponent;
import walnoot.libgdxutils.State;

public class GameState
extends State {
    public static final int WARP_TIME = 120;
    private GameWorld world;
    private WorldRenderer renderer;
    private int warpTimer = 120;
    private Entity player;
    private boolean playerDead;
    private int difficulty;
    private Sound warpSound = Assets.sounds.get("sounds/teleport");

    public GameState(PrototypeLoader loader) {
        this(loader, loader.createProto("player"), 1);
    }

    public GameState(PrototypeLoader loader, Entity player, int difficulty) {
        this.difficulty = difficulty;
        this.world = new GameWorld(loader);
        this.renderer = new WorldRenderer(this.world);
        float spawnX = MathUtils.random(-100.0f, 100.0f);
        float spawnY = MathUtils.random(-100.0f, 100.0f);
        float gateAngle = MathUtils.random((float)Math.PI * 2);
        float gateDist = 300.0f + 25.0f * (float)difficulty;
        float gateX = spawnX + MathUtils.sin(gateAngle) * gateDist;
        float gateY = spawnY + MathUtils.cos(gateAngle) * 300.0f;
        this.world.addEntity(player).getBody().setTransform(spawnX, spawnY, 0.0f);
        if (difficulty == 1) {
            player.get(ShipComponent.class).equip(Util.getGun(difficulty));
        }
        this.world.addEntity("warpgate").getBody().setTransform(gateX, gateY, 0.0f);
        float enemyDensity = Math.max(40.0f, 120.0f - (float)difficulty * 5.0f);
        int x = -10;
        while (x <= 10) {
            int y = -10;
            while (y <= 10) {
                if (x != 0 || y != 0) {
                    float rx = MathUtils.random(-enemyDensity / 8.0f, enemyDensity / 8.0f);
                    float ry = MathUtils.random(-enemyDensity / 8.0f, enemyDensity / 8.0f);
                    Entity enemy = this.world.addEntity("enemy");
                    enemy.getBody().setTransform((float)x * enemyDensity + spawnX + rx, (float)y * enemyDensity + spawnY + ry, 0.0f);
                    enemy.get(ShipComponent.class).equip(Util.getGun(difficulty));
                    float health = 0.5f + (float)difficulty * 0.5f;
                    enemy.get(HealthComponent.class).setMaxHealth(health);
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void render() {
        this.renderer.render(this.getWarpTime(), this.difficulty);
    }

    @Override
    public void update() {
        this.world.update();
        this.playerDead = true;
        this.world.forAllEntities(e -> {
            if (e.has(WarpgateComponent.class)) {
                if (e.get(WarpgateComponent.class).isWarping()) {
                    ++this.warpTimer;
                    if (this.warpTimer > 120) {
                        this.warpTimer = 120;
                    }
                } else {
                    --this.warpTimer;
                    if (this.warpTimer < 0) {
                        this.warpTimer = 0;
                    }
                }
            }
            if (e.has(PlayerComponent.class)) {
                this.player = e;
                this.playerDead = false;
            }
        });
        if (this.playerDead && Gdx.input.isKeyJustPressed(62)) {
            this.manager.transitionTo((State)new GameState(this.world.getLoader()), 0.5f);
        }
        if (this.warpTimer == 120) {
            this.world.forAllEntities(e -> {
                if (e.has(PlayerComponent.class)) {
                    e.get(HealthComponent.class).heal(8.0f);
                }
            });
            this.warpSound.play();
            this.manager.setState(new GameState(this.world.getLoader(), this.player, this.difficulty + 1));
        }
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.renderer.resize(width, height);
    }

    public float getWarpTime() {
        return (float)this.warpTimer / 120.0f;
    }
}

