/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.StateApplication;
import walnoot.libgdxutils.Transition;

public class TransitionState
extends State {
    private State startState;
    private State endState;
    private boolean dirty = true;
    private FrameBuffer startBuffer;
    private FrameBuffer endBuffer;
    private SpriteBatch batch = new SpriteBatch(2);
    private float timeLeft;
    private Transition transition;
    private TextureRegion startRegion;
    private TextureRegion endRegion;

    public TransitionState(State startState, State endState, Transition transition) {
        this.startState = startState;
        this.endState = endState;
        this.transition = transition;
        this.timeLeft = transition.time;
    }

    @Override
    public void update() {
        this.timeLeft -= this.getDelta();
        if (this.timeLeft <= 0.0f) {
            this.manager.setState(this.endState);
        }
        if (this.transition.updateStartState) {
            this.startState.update();
        }
        if (this.transition.updateEndState) {
            this.endState.update();
        }
    }

    @Override
    public void render() {
        if (this.transition.updateStartState || this.dirty) {
            this.renderToBuffer(this.startBuffer, this.startState);
        }
        if (this.transition.updateEndState || this.dirty) {
            this.renderToBuffer(this.endBuffer, this.endState);
        }
        this.dirty = false;
        float alpha = this.timeLeft / this.transition.time;
        this.batch.begin();
        this.transition.renderTransition(this.batch, this.startRegion, this.endRegion, alpha);
        this.batch.end();
    }

    private void renderToBuffer(FrameBuffer buffer, State state) {
        this.manager.getRenderContext().setCurrentTarget(buffer);
        state.render();
        this.manager.getRenderContext().endCurruntTarget();
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.dirty = true;
        if (!creation) {
            this.startState.resize(false, width, height);
            this.endState.resize(false, width, height);
        }
        if (this.startBuffer != null) {
            this.startBuffer.dispose();
        }
        if (this.endBuffer != null) {
            this.endBuffer.dispose();
        }
        this.startBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        this.endBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        this.startRegion = new TextureRegion(this.startBuffer.getColorBufferTexture());
        this.startRegion.flip(false, true);
        this.endRegion = new TextureRegion(this.endBuffer.getColorBufferTexture());
        this.endRegion.flip(false, true);
        OrthographicCamera camera = new OrthographicCamera();
        camera.setToOrtho(false, 1.0f, 1.0f);
        camera.position.set(0.5f, 0.5f, 0.0f);
        camera.update();
        this.batch.setProjectionMatrix(camera.combined);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
        if (this.startBuffer != null) {
            this.startBuffer.dispose();
        }
        if (this.endBuffer != null) {
            this.endBuffer.dispose();
        }
        this.startBuffer = null;
        this.endBuffer = null;
    }

    @Override
    public void setManager(StateApplication manager) {
        super.setManager(manager);
        this.startState.setManager(manager);
        this.endState.setManager(manager);
    }

    @Override
    public State[] getManagedStates() {
        return new State[]{this.startState, this.endState};
    }
}

