/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;

public abstract class Transition {
    public boolean updateStartState;
    public boolean updateEndState;
    public final float time;

    public Transition(float time) {
        this(false, false, time);
    }

    public Transition(boolean updateStartState, boolean updateEndState, float time) {
        this.updateStartState = updateStartState;
        this.updateEndState = updateEndState;
        this.time = time;
    }

    public abstract void renderTransition(SpriteBatch var1, TextureRegion var2, TextureRegion var3, float var4);

    public Transition updateStart() {
        this.updateStartState = true;
        return this;
    }

    public Transition updateEnd() {
        this.updateEndState = true;
        return this;
    }

    public static class FadeTransition
    extends Transition {
        public FadeTransition(float time) {
            super(time);
        }

        @Override
        public void renderTransition(SpriteBatch batch, TextureRegion startRegion, TextureRegion endRegion, float alpha) {
            batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            batch.draw(startRegion, 0.0f, 0.0f, 1.0f, 1.0f);
            batch.setColor(1.0f, 1.0f, 1.0f, 1.0f - alpha);
            batch.draw(endRegion, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    public static class SlideTransition
    extends Transition {
        private boolean animateStartScreen;
        private Direction dir;
        private Interpolation interpolation = Interpolation.linear;

        public SlideTransition(float time, Direction dir) {
            super(time);
            this.dir = dir;
        }

        public SlideTransition(float time) {
            this(time, Direction.UP);
        }

        @Override
        public void renderTransition(SpriteBatch batch, TextureRegion startRegion, TextureRegion endRegion, float alpha) {
            float endX = this.dir.x * this.interpolation.apply(alpha);
            float endY = this.dir.y * this.interpolation.apply(alpha);
            float startX = this.animateStartScreen ? endX - this.dir.x : 0.0f;
            float startY = this.animateStartScreen ? endY - this.dir.y : 0.0f;
            batch.draw(startRegion, startX, startY, 1.0f, 1.0f);
            batch.draw(endRegion, endX, endY, 1.0f, 1.0f);
        }

        public SlideTransition animateStartScreen() {
            this.animateStartScreen = true;
            return this;
        }

        public SlideTransition interpolate(Interpolation i) {
            this.interpolation = i;
            return this;
        }

        public static enum Direction {
            UP(0.0f, 1.0f),
            RIGHT(1.0f, 0.0f),
            DOWN(0.0f, -1.0f),
            LEFT(-1.0f, 0.0f);

            private float x;
            private float y;

            private Direction(float x, float y) {
                this.x = x;
                this.y = y;
            }
        }
    }
}

