/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Array;
import walnoot.libgdxutils.RenderContext;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.Transition;
import walnoot.libgdxutils.TransitionState;

public abstract class StateApplication
extends ApplicationAdapter {
    private State state;
    private float updateDelta;
    private float unprocessedSeconds;
    private int[] updateTimes = new int[60];
    private int[] renderTimes = new int[60];
    private int updateTimesIndex;
    private int renderTimesIndex;
    private BitmapFont font;
    private SpriteBatch batch;
    private RenderContext renderContext = new RenderContext();
    private int currentLine;
    private boolean debug;
    private boolean firstTimeResize = true;

    public StateApplication(float updateFPS) {
        this(updateFPS, false);
    }

    public StateApplication(float updateFPS, boolean debug) {
        this.debug = debug;
        this.updateDelta = 1.0f / updateFPS;
    }

    @Override
    public void create() {
        if (this.debug) {
            this.font = new BitmapFont();
            this.font.setFixedWidthGlyphs("1234567890");
            this.batch = new SpriteBatch();
        }
        this.init();
        this.setState(this.getFirstState());
    }

    protected void init() {
    }

    protected abstract State getFirstState();

    @Override
    public void render() {
        this.unprocessedSeconds += Gdx.graphics.getDeltaTime();
        while (this.unprocessedSeconds > this.updateDelta) {
            this.unprocessedSeconds -= this.updateDelta;
            this.update();
        }
        long startTime = System.nanoTime();
        this.state.render();
        this.renderTimes[this.renderTimesIndex] = (int)(System.nanoTime() - startTime);
        this.renderTimesIndex = (this.renderTimesIndex + 1) % this.renderTimes.length;
        if (this.debug && Gdx.input.isKeyPressed(244)) {
            this.drawDebug();
        }
        if (this.debug && Gdx.input.isKeyPressed(this.getExitKey())) {
            Gdx.app.exit();
        }
    }

    protected int getExitKey() {
        return 131;
    }

    private void drawDebug() {
        this.batch.begin();
        this.currentLine = 0;
        this.font.draw(this.batch, "FPS: " + Gdx.graphics.getFramesPerSecond(), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, "Render time (avg): " + this.getAverage(this.renderTimes), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, "Render time (peak): " + this.getPeak(this.renderTimes), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, "Update time (avg): " + this.getAverage(this.updateTimes), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, "Update time (peak): " + this.getPeak(this.updateTimes), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, FrameBuffer.getManagedStatus(), 0.0f, this.getNextLineHeight());
        this.font.draw(this.batch, Texture.getManagedStatus(), 0.0f, this.getNextLineHeight());
        this.batch.end();
    }

    private int getNextLineHeight() {
        return (int)((float)Gdx.graphics.getHeight() - (float)this.currentLine++ * this.font.getLineHeight());
    }

    private String formatTime(int time) {
        return String.format("%.2f ms", Float.valueOf((float)time / 1000000.0f));
    }

    private String getAverage(int[] times) {
        int sum = 0;
        int i = 0;
        while (i < times.length) {
            sum += times[i];
            ++i;
        }
        return this.formatTime(sum / times.length);
    }

    private String getPeak(int[] times) {
        int peak = 0;
        int i = 0;
        while (i < times.length) {
            if (times[i] > peak) {
                peak = times[i];
            }
            ++i;
        }
        return this.formatTime(peak);
    }

    protected void update() {
        long startTime = System.nanoTime();
        this.state.update();
        this.updateTimes[this.updateTimesIndex] = (int)(System.nanoTime() - startTime);
        this.updateTimesIndex = (this.updateTimesIndex + 1) % this.updateTimes.length;
    }

    public void setState(State newState) {
        State oldState = this.state;
        this.state = newState;
        Array<State> oldStates = new Array<State>(false, 4);
        Array<State> newStates = new Array<State>(false, 4);
        this.fillStateList(oldStates, oldState);
        this.fillStateList(newStates, newState);
        for (State s : oldStates) {
            if (newStates.contains(s, true)) continue;
            s.hide();
        }
        for (State s : newStates) {
            if (oldStates.contains(s, true)) continue;
            s.setManager(this);
            s.show();
            s.resize(true, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }
    }

    private void fillStateList(Array<State> states, State state) {
        if (state != null) {
            states.add(state);
            State[] managedStates = state.getManagedStates();
            if (managedStates != null) {
                int i = 0;
                while (i < managedStates.length) {
                    this.fillStateList(states, managedStates[i]);
                    ++i;
                }
            }
        }
    }

    public void transitionTo(State newState, Transition transition) {
        this.setState(new TransitionState(this.state, newState, transition));
    }

    @Override
    public void resize(int width, int height) {
        if (this.debug) {
            OrthographicCamera camera = new OrthographicCamera();
            camera.setToOrtho(false);
            this.batch.setProjectionMatrix(camera.combined);
        }
        if (!this.firstTimeResize) {
            this.state.resize(false, width, height);
        }
        this.firstTimeResize = false;
    }

    public State getCurrentState() {
        return this.state;
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public float getDelta() {
        return this.updateDelta;
    }

    public boolean isTransitioning() {
        return this.state instanceof TransitionState;
    }
}

