/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import walnoot.ld32.Component;
import walnoot.ld32.OffsetSprite;

public class SpriteComponent
extends Component {
    private Array<OffsetSprite> sprites = new Array();
    private Vector2 tmp = new Vector2();

    public SpriteComponent() {
    }

    public SpriteComponent(TextureRegion region) {
        this(region, 1.0f);
    }

    public SpriteComponent(TextureRegion region, float size) {
        this(region, size, 0.0f);
    }

    public SpriteComponent(TextureRegion region, float size, float rotation) {
        this.addSprite(region, size, 0.0f, 0.0f, rotation);
    }

    @Override
    public void render(Array<Sprite> spriteList) {
        for (OffsetSprite s : this.sprites) {
            this.tmp.set(s.offsetX, s.offsetY).rotate(s.getRotation());
            s.setCenter(this.owner.getX() + this.tmp.x, this.owner.getY() + this.tmp.y);
            spriteList.add(s);
        }
    }

    public OffsetSprite addSprite(TextureRegion region, float size) {
        return this.addSprite(region, size, 0.0f, 0.0f, 0.0f);
    }

    public OffsetSprite addSprite(TextureRegion region, float size, float offsetX, float offsetY, float rotation) {
        return this.addSprite(region, size, offsetX, offsetY, rotation, 0);
    }

    public OffsetSprite addSprite(TextureRegion region, float size, float offsetX, float offsetY, float rotation, int level) {
        OffsetSprite sprite = new OffsetSprite(region, level);
        sprite.offsetX = offsetX;
        sprite.offsetY = offsetY;
        sprite.setSize(size, size);
        sprite.setOriginCenter();
        sprite.setRotation(rotation);
        this.sprites.add(sprite);
        return sprite;
    }

    public SpriteComponent setLevel(int level) {
        for (OffsetSprite sprite : this.sprites) {
            sprite.level = level;
        }
        return this;
    }
}

