/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import walnoot.ld32.Assets;
import walnoot.ld32.Component;
import walnoot.ld32.Input;
import walnoot.ld32.OffsetSprite;
import walnoot.ld32.PlayerData;
import walnoot.ld32.components.BodyInfoComponent;
import walnoot.ld32.components.BulletComponent;
import walnoot.ld32.components.SpriteComponent;

public class PlayerComponent
extends Component {
    private static final int MAX_FIRE_TIME = 60;
    private static final float DEADZONE = 0.2f;
    private static final float SPEED = 8.0f;
    private static final float UI_WIDTH = 2.0f;
    private static final float UI_HEIGHT = 0.5f;
    private static final float UI_BORDER = 0.1f;
    private Vector2 moveDir = new Vector2();
    private Vector2 aimDir = new Vector2(0.0f, 1.0f);
    private boolean firing;
    private int firingTimer;
    private Vector2 tmp = new Vector2();
    private OffsetSprite playerSprite;
    private OffsetSprite bowSprite;
    private OffsetSprite arrowSprite;
    private OffsetSprite uiBorderSprite;
    private OffsetSprite uiFillSprite;
    private Color uiColor = new Color();
    private OrthographicCamera camera;
    private final PlayerData data;

    public PlayerComponent(OrthographicCamera camera, PlayerData data) {
        this.camera = camera;
        this.data = data;
    }

    @Override
    public void init() {
        this.uiBorderSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("box"), 1.0f, 0.0f, -2.0f, 0.0f);
        this.uiBorderSprite.setScale(2.0f, 0.5f);
        this.uiFillSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("box"), 1.0f, 0.0f, -2.0f, 0.0f);
        this.uiFillSprite.setScale(0.0f, 0.0f);
        this.uiFillSprite.setColor(Color.BLACK);
        this.bowSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("bow"), 1.5f, 0.0f, 1.0f, 0.0f);
        this.bowSprite.setAlpha(0.0f);
        this.arrowSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("arrow"), 1.5f, 0.0f, 1.0f, 0.0f);
        this.arrowSprite.setAlpha(0.0f);
        this.playerSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("player"), 1.0f);
        this.playerSprite.setColor(Color.LIGHT_GRAY);
        this.owner.getComponent(SpriteComponent.class).setLevel(1);
    }

    @Override
    public void update() {
        boolean canFire;
        this.moveDir.set(0.0f, 0.0f);
        this.aimDir.set(0.0f, 0.0f);
        this.firing = false;
        if (this.owner.world.useController()) {
            Controller c = Controllers.getControllers().get(0);
            this.tmp.set(0.0f, 0.0f).add(c.getAxis(1), -c.getAxis(0));
            if (this.tmp.len2() > 0.040000003f) {
                this.moveDir.add(this.tmp);
            }
            this.tmp.set(0.0f, 0.0f).add(c.getAxis(3), -c.getAxis(2));
            if (this.tmp.len2() > 0.040000003f) {
                this.aimDir.add(this.tmp);
            }
            if (c.getButton(5) && !this.aimDir.isZero()) {
                this.firing = true;
            }
        } else {
            if (Input.i.getKey("up").isTouched()) {
                this.moveDir.add(0.0f, 1.0f);
            }
            if (Input.i.getKey("down").isTouched()) {
                this.moveDir.add(0.0f, -1.0f);
            }
            if (Input.i.getKey("left").isTouched()) {
                this.moveDir.add(-1.0f, 0.0f);
            }
            if (Input.i.getKey("right").isTouched()) {
                this.moveDir.add(1.0f, 0.0f);
            }
            if (Gdx.input.isButtonPressed(0)) {
                this.firing = true;
            }
            Vector2 mousePosition = Input.i.getMousePosition(this.owner.world.getCamera(), this.tmp);
            this.aimDir.set(mousePosition).sub(this.owner.body.getPosition());
        }
        if (this.data.getArrows() <= 0) {
            this.firing = false;
        }
        this.aimDir.nor();
        float spriteAngle = this.aimDir.angle() - 90.0f;
        this.owner.body.setLinearVelocity(this.moveDir.limit2(1.0f).scl(8.0f));
        if (this.firing && this.firingTimer < 60) {
            ++this.firingTimer;
        }
        boolean bl = canFire = this.firingTimer > 30;
        if (!this.aimDir.isZero() && !this.firing && canFire) {
            this.owner.world.addEntity(this.owner.getX() + this.aimDir.x, this.owner.getY() + this.aimDir.y, new SpriteComponent(Assets.get("arrow"), 1.5f, spriteAngle), new BulletComponent(PlayerComponent.class, this.aimDir, 15.0f, 0.5f), new BodyInfoComponent(false));
            this.data.removeArrow();
        }
        if (!this.firing) {
            this.firingTimer = 0;
        }
        this.setSprites(spriteAngle, canFire);
        this.moveCamera();
    }

    @Override
    public void render(Array<Sprite> sprites) {
        if (Gdx.input.isKeyJustPressed(57)) {
            Input.i.getMousePosition(this.camera, this.tmp);
            System.out.printf("int pos: [%d, %d]\nfloat pos: [%.2f, %.2f]\n", (int)Math.floor(this.tmp.x), (int)Math.floor(this.tmp.y), Float.valueOf(this.tmp.x), Float.valueOf(this.tmp.y));
        }
    }

    private void setSprites(float spriteAngle, boolean canFire) {
        this.bowSprite.setScale(1.5f, 1.5f * this.getFiringStrength() + 0.5f);
        if (this.firingTimer == 60) {
            this.bowSprite.offsetX = MathUtils.random(0.05f);
            this.bowSprite.offsetY = MathUtils.random(0.05f) + 1.0f;
        }
        this.bowSprite.setAlpha(this.aimDir.isZero() ? 0.0f : 1.0f);
        this.bowSprite.setRotation(spriteAngle);
        this.arrowSprite.setAlpha(this.firing ? 1.0f : 0.0f);
        this.arrowSprite.offsetY = 1.75f - this.getFiringStrength() * 0.75f;
        this.arrowSprite.setRotation(spriteAngle);
        this.playerSprite.setRotation(spriteAngle);
        this.uiFillSprite.setScale(1.9f * ((float)this.firingTimer / 60.0f), 0.4f);
        if (this.firingTimer == 60) {
            this.uiColor.lerp(Color.RED, 0.2f);
        } else if (canFire) {
            this.uiColor.lerp(Color.GREEN, 0.2f);
        } else {
            this.uiColor.lerp(Color.BLACK, 0.2f);
        }
        this.uiFillSprite.setColor(this.uiColor);
    }

    private void moveCamera() {
        Vector3 cpos = this.camera.position;
        cpos.set(this.tmp.set(this.owner.body.getPosition()).sub(cpos.x, cpos.y).scl(0.05f).add(cpos.x, cpos.y), 0.0f);
    }

    private float getFiringStrength() {
        return (float)Math.pow(Math.min((float)this.firingTimer / 60.0f, 1.0f), 0.4f);
    }

    public PlayerData getData() {
        return this.data;
    }
}

