/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import walnoot.ld32.Component;

public class HealthComponent
extends Component {
    private static final int INVINCIBILITY_TIME = 15;
    private int health;
    private int maxHealth;
    private int invincibilityTimer;

    public HealthComponent(int maxHealth) {
        this.maxHealth = maxHealth;
        this.health = maxHealth;
    }

    @Override
    public void update() {
        if (this.invincibilityTimer > 0) {
            --this.invincibilityTimer;
        }
    }

    public int hit(int amount) {
        if (amount < 0) {
            return 0;
        }
        if (this.invincibilityTimer > 0) {
            return 0;
        }
        this.invincibilityTimer = 15;
        int damageDone = Math.min(amount, amount - this.health);
        this.health -= amount;
        if (this.health <= 0) {
            this.health = 0;
            this.owner.remove();
        }
        return damageDone;
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }
}

