/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import com.badlogic.gdx.physics.box2d.Fixture;
import walnoot.ld32.Component;
import walnoot.ld32.Entity;
import walnoot.ld32.components.EnemyComponent;
import walnoot.ld32.components.PlayerComponent;

public class ExitComponent
extends Component {
    private String level;
    private int timer;
    private boolean cleared = false;

    public ExitComponent(String level) {
        this.level = level;
    }

    @Override
    public void update() {
        if (!this.cleared) {
            if (this.owner.world.findEntityWith(EnemyComponent.class) == null) {
                this.cleared = true;
                for (Fixture f : this.owner.body.getFixtureList()) {
                    this.owner.body.destroyFixture(f);
                }
            }
        } else {
            for (Entity e : this.owner.world.queryRadius(this.owner, 2.0f)) {
                if (!e.hasComponent(PlayerComponent.class)) continue;
                ++this.timer;
            }
            if (this.timer > 0) {
                ++this.timer;
            }
            if ((float)this.timer > 30.0f) {
                this.owner.world.markFinished(this.level);
            }
        }
    }
}

